#!/usr/bin/env bash

# 执行代码前，先输出待执行的代码行
set -x
# 脚本发生错误则立即终止执行
set -e

export ANDROID_HOME=$CID_CACHE_DIR/buildbox/android-sdk-34.0.5
export PATH=${PATH}:${ANDROID_HOME}/tools
export PATH=${PATH}:${ANDROID_HOME}/platform-tools
export ANDROID_NDK_HOME=$CID_CACHE_DIR/buildbox/android-ndk-r21b
export APPENDIX=${CID_REPO_BRANCH}-${CID_BUILD_TIME}

export PACKAGE_PREFIX=HWMUiSdk
export PACKAGE_NAME=${PACKAGE_PREFIX}-${PACKAGE_TAG}-${APPENDIX}.zip

export APK_PREFIX=HWMDemo

cd ${CID_WORKSPACE}/uisdk

originZip=`find .  -name "*.zip"`
unzip ${originZip}
rm -fr ${originZip}

uisdkZip=`find . -name "*.zip" | grep -v welink`
unzip ${uisdkZip}

mv *.aar ../libs/
cd ${CID_WORKSPACE}

sed -i "s?classpath 'com.android.tools.build:gradle:3.5.2'?classpath 'com.android.tools.build:gradle:3.6.3'?g" build.gradle
sed -i "s?implementation(name: 'HWMUisdk-release', ext: 'aar')?implementation(name: 'HWMUiSdk-release', ext: 'aar')?g" app/build.gradle
sed -i "s?implementation(name: 'HWMClink-release', ext: 'aar')?implementation(name: 'HWMCLink-release', ext: 'aar')?g" app/build.gradle

sed -i "s/needScreenShare.*/needScreenShare=true/" gradle.properties
gradle :app:assembleRelease
find app/build -name "*-release.apk" -exec mv {} ${CID_WORKSPACE}/uisdk/${APK_PREFIX}-release-${APPENDIX}.apk \;

sed -i "s/needScreenShare.*/needScreenShare=false/" gradle.properties
gradle :app:assembleRelease
find app/build -name "*-release.apk" -exec mv {} ${CID_WORKSPACE}/uisdk/${APK_PREFIX}-noshare-release-${APPENDIX}.apk \;

cd ${CID_WORKSPACE}/uisdk/
zip -j ${PACKAGE_NAME} *
find . -name "*.zip" | grep -v ${PACKAGE_PREFIX} | xargs rm -fr
