package com.huawei.hwmdemo;

import android.annotation.SuppressLint;
import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;

import com.huawei.cloudlink.applicationdi.ActivityLifecycleHandle;
import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.cloudlink.openapi.OpenSDKConfig;
import com.huawei.cloudlink.openapi.api.param.LanguageType;
import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmdemo.delegate.DelegateHolder;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.model.ModeType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.vision.utils.ModeUtil;
import com.huawei.hwmlogger.HCLog;
import com.huawei.hwmsdk.common.SdkCallback;
import com.huawei.hwmsdk.enums.SDKERR;

public class DemoApplication extends Application {

    private static final String TAG = "DemoApplication";


    @SuppressLint("IfLackElseCheck")
    @Override
    public void onCreate() {
        super.onCreate();

        DemoUtil.setApplication(this);

        OpenSDKConfig sdkConfig = new OpenSDKConfig(this)
                .setAppId(DemoUtil.getAppId(this)) //向会议服务器申请的appid
                .setNeedConfChat("true".equals(BuildConfig.needConfChat))
                .setNeedScreenShare("true".equals(BuildConfig.needScreenShare))
                .setSupportTransferChairOnLeave(true)
                .setNeedFeedback(false)
                .setRoomsMode(ModeUtil.getModeType(this) == ModeType.VISION);

        DelegateHolder.init(sdkConfig);

        DelegateHolder.getHwmUiDelegate().initOpenSdkUIConfig(sdkConfig);

        if (DemoUtil.needCustom(NeedCustomType.ASYNC_INIT_SDK_CONFIG)) {
            //异步初始化
            HCLog.i(TAG, " enter init async ");
            //注册Activity生命周期监听【重要】
            registerActivityLifecycleCallbacks(new ActivityLifecycleHandle());
            //子线程初始化
            new Thread(() -> HWMSdk.initAsync(this, sdkConfig, new SdkCallback<Integer>() {
                @Override
                public void onFailed(SDKERR sdkerr) {
                    HCLog.e(TAG, " async init failed : " + sdkerr.getDescription());
                }

                @Override
                public void onSuccess(Integer integer) {
                    HCLog.i(TAG, " async init success : " + integer);
                    new Handler(Looper.getMainLooper()).post(() -> DelegateHolder.getHwmSettingDelegate().initSettingConfig());
                }
            })).start();
        } else {
            //同步初始化
            HCLog.i(TAG, " enter init sync ");
            HWMSdk.init(this, sdkConfig);
            DelegateHolder.getHwmSettingDelegate().initSettingConfig();
        }

        configFloatingView();
        String customLanguage = DemoUtil.getCustomLanguage();
        if (!TextUtils.isEmpty(customLanguage)) {
            if (TextUtils.equals("zh-CN", customLanguage)) {
                HWMSdk.getOpenApi(DemoUtil.getApplication()).setLanguage(LanguageType.LANGUAGE_TYPE_CN_ZH, "zh-CN");
            } else if (TextUtils.equals("en", customLanguage)) {
                HWMSdk.getOpenApi(DemoUtil.getApplication()).setLanguage(LanguageType.LANGUAGE_TYPE_EN, "en");
            } else if (TextUtils.equals("ar", customLanguage)) {
                HWMSdk.getOpenApi(DemoUtil.getApplication()).setLanguage(LanguageType.LANGUAGE_TYPE_CUSTOMIZED, "ar");
            }
        }

        // 关闭SDK日志自动收集与上报会中打点功能
        if (DemoUtil.needCustom(NeedCustomType.ALLOW_MEETING_UT)) {
            HWMBizSdk.getBizOpenApi().setAllowMeetingUt(false);
        }

    }

    private void configFloatingView() {
        //配置了自定义悬浮窗后，悬浮窗会横向显示在左上角
        if (DemoUtil.needCustom(NeedCustomType.FLOATING_VIEW_STYLE_CONFIG)) {
            HWMSdk.getOpenApi(this).setFloatWindowInitialOrientation(0);
            HWMSdk.getOpenApi(this).setFloatWindowInitialPosition(100, 0);
        } else {
            HWMSdk.getOpenApi(this).setFloatWindowInitialOrientation(1);
            HWMSdk.getOpenApi(this).setFloatWindowInitialPosition(-1, -1);
        }
    }
}
