package com.huawei.hwmdemo.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.model.ApiPageModel;

import java.util.List;

public class MyRecyclerViewAdapter extends RecyclerView.Adapter<MyRecyclerViewAdapter.ViewHolder> {
    private List<ApiPageModel> list;

    private OnItemClickListener onItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public MyRecyclerViewAdapter(List<ApiPageModel> list) {
        this.list = list;
    }

    @NonNull
    @Override
    public MyRecyclerViewAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.main_item, parent, false);
        return new MyRecyclerViewAdapter.ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull MyRecyclerViewAdapter.ViewHolder holder, int position) {
        ApiPageModel model = list.get(position);
        holder.mText.setText(model.name);
        if (model.isShowCheck) {
            holder.mCheckBox.setVisibility(View.VISIBLE);
            holder.mCheckBox.setChecked(model.checkStyle);
        } else {
            holder.mCheckBox.setVisibility(View.GONE);
        }
        int adapterPosition = holder.getBindingAdapterPosition();
        if (onItemClickListener != null) {
            holder.itemView.setOnClickListener(new MyOnClickListener(position, list.get(adapterPosition)));
            holder.itemView.setOnLongClickListener(new MyOnLongClickListener(position, list.get(adapterPosition)));
        }
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        TextView mText;

        CheckBox mCheckBox;

        ViewHolder(View itemView) {
            super(itemView);
            mText = itemView.findViewById(R.id.main_item_text);
            mCheckBox = itemView.findViewById(R.id.main_item_checkbox);
        }
    }

    private class MyOnClickListener implements View.OnClickListener {
        private int position;

        private ApiPageModel data;

        public MyOnClickListener(int position, ApiPageModel data) {
            this.position = position;
            this.data = data;
        }

        @Override
        public void onClick(View v) {
            onItemClickListener.onItemClick(v, position, data);
        }
    }

    private class MyOnLongClickListener implements View.OnLongClickListener {
        private int position;

        private ApiPageModel data;

        public MyOnLongClickListener(int position, ApiPageModel data) {
            this.position = position;
            this.data = data;
        }

        @Override
        public boolean onLongClick(View v) {
            onItemClickListener.onItemLongClick(v, position, data);
            return true;
        }
    }

    public interface OnItemClickListener {
        void onItemClick(View view, int position, ApiPageModel data);

        void onItemLongClick(View view, int position, ApiPageModel data);
    }
}