package com.huawei.hwmdemo.adapter;

import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmdemo.R;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PeopleListItemAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder>
    implements View.OnClickListener {

    private List<AttendeeModel> items;

    private OnItemClickListener mOnItemClickListener;

    //是否显示单选框,默认false
    private boolean isshowBox = true;

    // 存储勾选框状态的map集合
    private Map<Integer, Boolean> map = new HashMap<>();

    public PeopleListItemAdapter() {
        this.items = new ArrayList<>();
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View v = LayoutInflater.from(viewGroup.getContext())
            .inflate(R.layout.personnel_item, viewGroup, false);
        v.setOnClickListener(this);
        return new ContentViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        AttendeeModel item = items.get(i);
        ((ContentViewHolder) viewHolder).name.setText(getItemName(item));
        viewHolder.itemView.setTag(i);
        ((ContentViewHolder) viewHolder).checkBox.setOnCheckedChangeListener(
            new CompoundButton.OnCheckedChangeListener() {

                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    map.put(i, isChecked);
                }
            });
        if (map.get(i) == null) {
            map.put(i, false);
        }
        ((ContentViewHolder) viewHolder).checkBox.setChecked(map.get(i));
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    @Override
    public int getItemCount() {
        if (items != null) {
            return items.size();
        }
        return 0;
    }

    public void updateConfList(List<AttendeeModel> list) {
        if (items != null) {
            items.clear();
        }
        if (list != null && list.size() > 0) {
            if (items != null) {
                items.addAll(list);
            }
        }
        notifyDataSetChanged();
    }

    //设置是否显示CheckBox
    public void setShowBox() {
        //取反
        isshowBox = !isshowBox;
    }

    //点击item选中CheckBox
    public void setSelectItem(int position) {
        //对当前状态取反
        if (map.get(position)) {
            map.put(position, false);
        } else {
            map.put(position, true);
        }
        notifyItemChanged(position);
    }

    @Override
    public void onClick(View v) {
        if (mOnItemClickListener != null) {
            mOnItemClickListener.onItemClick(v, (int) v.getTag());
        }
    }

    private String getItemName(AttendeeModel item) {
        if (item == null) {
            return "";
        }
        if (TextUtils.isEmpty(item.getName())) {
            if (!TextUtils.isEmpty(item.getThirdUserId())) {
                return item.getThirdUserId();
            }
            if (!TextUtils.isEmpty(item.getNumber())) {
                return item.getNumber();
            }
        }
        return item.getName();
    }

    class ContentViewHolder extends RecyclerView.ViewHolder {
        TextView name;

        CheckBox checkBox;

        ContentViewHolder(View itemView) {
            super(itemView);
            name = itemView.findViewById(R.id.demo_personnel_item_name_text);
            checkBox = itemView.findViewById(R.id.demo_personnel_item_choose_check);
        }
    }

    public Map<Integer, Boolean> getMap() {
        return map;
    }

    public void setMap(Map<Integer, Boolean> map) {
        this.map = map;
    }

    public interface OnItemClickListener {
        void onItemClick(View view, int position);
    }
}
