package com.huawei.hwmdemo.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmdemo.R;

import java.util.List;

public class ToastLogsAdapter extends RecyclerView.Adapter<ToastLogsAdapter.ToastLogsViewHolder> {

    private List<String> toastLogs;

    public ToastLogsAdapter(List<String> toastLogs) {
        this.toastLogs = toastLogs;
    }

    @Override
    public ToastLogsViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_toast_log, parent, false);
        return new ToastLogsViewHolder(view);
    }

    @Override
    public void onBindViewHolder(ToastLogsViewHolder holder, int position) {
        String toastLog = toastLogs.get(position);
        holder.bind(toastLog);
    }

    @Override
    public int getItemCount() {
        return toastLogs.size();
    }

    public static class ToastLogsViewHolder extends RecyclerView.ViewHolder {

        private TextView toastLogTextView;

        public ToastLogsViewHolder(View itemView) {
            super(itemView);
            toastLogTextView = itemView.findViewById(R.id.toast_log_text_view);
        }

        public void bind(String toastLog) {
            toastLogTextView.setText(toastLog);
        }
    }
}
