package com.huawei.hwmdemo.adapter;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmconf.sdk.model.conf.entity.VmrInfoModel;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.ArrayList;
import java.util.List;

public class VmrListItemAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private static final String TAG = "VmrListItemAdapter";

    private final List<VmrInfoModel> items;

    private final Listener listener;

    public VmrListItemAdapter(Listener listener) {
        this.items = new ArrayList<>();
        this.listener = listener;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View itemView = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.vmr_item, viewGroup, false);
        final ContentViewHolder contentViewHolder = new ContentViewHolder(itemView);
        contentViewHolder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    VmrInfoModel item = items.get(contentViewHolder.getBindingAdapterPosition());
                    if (listener != null && item != null) {
                        listener.onItemClicked(item);
                    }
                } catch (Exception e) {
                    Log.e(TAG, " click item error : " + e);
                }
            }
        });
        contentViewHolder.cancelConfBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    String guestPassword = contentViewHolder.vmrPwdEdit.getText().toString();
                    if (guestPassword.length() < 4) {
                        DemoUtil.showToast("来宾密码由4～6位数字组成");
                        return;
                    }
                    VmrInfoModel item = items.get(contentViewHolder.getBindingAdapterPosition());
                    if (listener != null && item != null) {
                        item.setGuestPwd(guestPassword);
                        listener.onModifyVmrPwdBtnClicked(item);
                    }
                } catch (Exception e) {
                    Log.e(TAG, " click cancel error : " + e);
                }
            }
        });
        return contentViewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        VmrInfoModel item = items.get(i);
        ((ContentViewHolder) viewHolder).vmrConfId.setVisibility(View.VISIBLE);
        ((ContentViewHolder) viewHolder).vmrType.setVisibility(View.VISIBLE);
        ((ContentViewHolder) viewHolder).vmrName.setVisibility(View.VISIBLE);
        ((ContentViewHolder) viewHolder).vmrConfId.setText(item.getVmrConferenceId());
        ((ContentViewHolder) viewHolder).vmrType.setText(item.getType().getDescription());
        ((ContentViewHolder) viewHolder).vmrName.setText(item.getName());
        ((ContentViewHolder) viewHolder).vmrPwdEdit.setText(item.getGuestPwd());
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void updateConfList(List<VmrInfoModel> list) {
        items.clear();
        if (list != null && list.size() > 0) {
            items.addAll(list);
        }
        notifyDataSetChanged();
    }

    class ContentViewHolder extends RecyclerView.ViewHolder {
        TextView vmrConfId;
        TextView vmrType;
        TextView vmrName;
        EditText vmrPwdEdit;
        TextView cancelConfBtn;

        ContentViewHolder(View itemView) {
            super(itemView);
            vmrConfId = itemView.findViewById(R.id.demo_vmr_item_confid_text);
            vmrType = itemView.findViewById(R.id.demo_conf_item_conf_vmr_type_text);
            vmrName = itemView.findViewById(R.id.demo_conf_item_vmr_name_text);
            vmrPwdEdit = itemView.findViewById(R.id.modify_pwd_edit);
            cancelConfBtn = itemView.findViewById(R.id.demo_conf_item_vmr_edit_btn);
        }
    }

    public interface Listener {
        void onItemClicked(VmrInfoModel item);

        void onModifyVmrPwdBtnClicked(VmrInfoModel item);
    }
}
