package com.huawei.hwmdemo.delegate;


import androidx.annotation.NonNull;

import com.huawei.cloudlink.openapi.OpenSDKConfig;
import com.huawei.hwmdemo.utils.DemoUtil;

public class DelegateHolder {

    private static IHwmUiDelegate sHwmUiDelegate = null;

    private static IHwmSettingDelegate sHwmSettingDelegate = null;

    private static IHwmFeatureDelegate sHwmFeatureDelegate = null;

    private static OpenSDKConfig sSdkConfig = null;

    public static void init(OpenSDKConfig sdkConfig) {
        sSdkConfig = sdkConfig;
    }

    @NonNull
    public static synchronized IHwmUiDelegate getHwmUiDelegate() {
        if (sHwmUiDelegate == null) {
            sHwmUiDelegate = DelegateFactory.createHwmUiDelegate(DemoUtil.getApplication(), sSdkConfig);
        }
        return sHwmUiDelegate;
    }

    @NonNull
    public static synchronized IHwmSettingDelegate getHwmSettingDelegate() {
        if (sHwmSettingDelegate == null) {
            sHwmSettingDelegate = DelegateFactory.createHwmSettingDelegate(DemoUtil.getApplication(), sSdkConfig);
        }
        return sHwmSettingDelegate;
    }

    @NonNull
    public static synchronized IHwmFeatureDelegate getHwmFeatureDelegate() {
        if (sHwmFeatureDelegate == null) {
            sHwmFeatureDelegate = DelegateFactory.createHwmFeatureDelegate(DemoUtil.getApplication(), sSdkConfig);
        }
        return sHwmFeatureDelegate;
    }
}
