package com.huawei.hwmdemo.dependency;

import android.util.Log;

import com.huawei.conflogic.HwmCallAllExternalAttendeesInfo;
import com.huawei.hwmbiz.BizNotificationHandler;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfBaseInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.HWMCorpConfigInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.OperateExternalInviteeInfo;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.sdk.IConfListUpdate;
import com.huawei.hwmfoundation.utils.GsonUtil;
import com.huawei.hwmfoundation.utils.SecurityUtils;
import com.huawei.hwmlogger.HCLog;
import com.huawei.hwmsdk.enums.ConfRole;
import com.huawei.hwmsdk.enums.LoginState;
import com.huawei.hwmsdk.enums.ShareWatchingStatus;
import com.huawei.hwmsdk.enums.UserCorpInfoNotifyType;
import com.huawei.hwmsdk.model.result.AddAttendeeResultList;
import com.huawei.hwmsdk.model.result.AttendeeInfo;
import com.huawei.hwmsdk.model.result.ConfIncomingInfo;
import com.huawei.hwmsdk.model.result.RealTimeSubtitle;
import com.huawei.hwmsdk.model.result.ShareVmrInfo;
import com.huawei.hwmsdk.model.result.SubtitleRecordInfo;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CustomBizNotificationHandle implements BizNotificationHandler {
    private static final String TAG = CustomBizNotificationHandle.class.getSimpleName();

    private static final CopyOnWriteArrayList<IConfListUpdate> sConfListChangedListeners = new CopyOnWriteArrayList<>();

    public static void registerConfListChangedListener(IConfListUpdate confListUpdate) {
        sConfListChangedListeners.add(confListUpdate);
    }

    public static void removeConfListChangedListener(IConfListUpdate confListUpdate) {
        sConfListChangedListeners.remove(confListUpdate);
    }

    //会议列表更新回调
    @Override
    public void onConfListChanged(List<ConfBaseInfo> list) {
        // 更新频率高，存储日志,界面不提示
        HCLog.i(TAG, "onConfListChanged List<ConfBaseInfo> count is " + (list == null ? 0 : list.size()));
        for (IConfListUpdate listener : sConfListChangedListeners) {
            try {
                listener.onConfListUpdateNotify(list);
            } catch (RuntimeException e) {
                Log.e("onConfListChanged", e.toString());
            }
        }
    }

    //个人角色是否是主持人更新回调
    @Override
    public void onIsSelfChairManChanged(boolean isChairman) {
        DemoUtil.showToast("BizNotificationHandler 事件：onIsSelfChairManChanged isChairman " + isChairman);
    }

    //与会者更新回调
    @Override
    public void onAttendeeListChanged(List<AttendeeInfo> attendeeInfoList) {
        // 更新频率高，存储日志,界面不提示
        HCLog.i(TAG, "onAttendeeListChanged attendeeInfoList count is " + (attendeeInfoList == null ? 0 : attendeeInfoList.size()));
        if (attendeeInfoList != null && !attendeeInfoList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("onAttendeeListChanged \n");
            for (AttendeeInfo attendeeInfo : attendeeInfoList) {
                if (attendeeInfo != null) {
                    stringBuilder.append("attendee userId : ").append(attendeeInfo.getUserId())
                            .append(", name : ").append(SecurityUtils.maskName(attendeeInfo.getName()))
                            .append(", isAnonymous : ").append(attendeeInfo.getIsAnonymous())
                            .append(", number : ").append(SecurityUtils.maskPhone(attendeeInfo.getNumber()))
                            .append(", isSelf : ").append(attendeeInfo.getIsSelf())
                            .append(", state : ").append(attendeeInfo.getState())
                            .append("\n");
                }
            }
            DemoUtil.addConsoleLog(stringBuilder.toString());
        }
    }

    @Override
    public void onWaitingListChanged(List<AttendeeInfo> waitingInfoList) {
        HCLog.i(TAG, "onWaitingListChanged waitingInfoList count is " + (waitingInfoList == null ? 0 : waitingInfoList.size()));
    }

    //会议录制权限通知
    @Override
    public void onRecordPermissionChanged(boolean hasPermission) {
        DemoUtil.showToast("BizNotificationHandler 事件：onRecordPermissionChanged hasPermission " + hasPermission);
    }

    //预约会议发送短信权限通知
    @Override
    public void onBookConfSmsPermissionChanged(boolean hasPermission) {
        DemoUtil.showToast("BizNotificationHandler 事件：onBookConfSmsPermissionChanged hasPermission " + hasPermission);
    }

    //会议纪要状态通知
    @Override
    public void onAIConfRecordStateChanged(int state) {
        DemoUtil.showToast("BizNotificationHandler 事件：onAIConfRecordStateChanged state " + state);
    }

    @Override
    public void onRecordTypeChanged(int type) {
        DemoUtil.showToast("BizNotificationHandler 事件：onRecordTypeChanged type " + type);
    }

    @Override
    public void onConfIncomingNotify(ConfIncomingInfo confIncomingInfo) {
        if (confIncomingInfo != null) {
            DemoUtil.showToast("BizNotificationHandler 事件：onConfIncomingNotify subject " + confIncomingInfo.getSubject() +
                    "\n confId: " + confIncomingInfo.getConfId() + ", vmrConfId: " + confIncomingInfo.getVmrConfId() +
                    "\n thirdUserId: " + confIncomingInfo.getThirdUserId() +
                    "\n inviteExtendedField: " + confIncomingInfo.getInviteExtendedField() +
                    "\n schedulerName: " + confIncomingInfo.getSchedulerName() +
                    "\n schedulerAliasCN: " + confIncomingInfo.getSchedulerAliasCN() +
                    "\n schedulerAliasEN: " + confIncomingInfo.getSchedulerAliasEN() +
                    "\n schedulerExtendedField: " + confIncomingInfo.getSchedulerExtendedField() +
                    "\n corpId: " + confIncomingInfo.getInviteCorpId());
        } else {
            HCLog.e(TAG, "confIncomingInfo is null");
        }
    }

    @Override
    public void onSelfShareStateChanged(boolean isShare) {
        DemoUtil.showToast("BizNotificationHandler 事件：onSelfShareStateChanged isShare " + isShare);
    }

    @Override
    public void onWatchingShareStatusChanged(int userId, ShareWatchingStatus status) {
        DemoUtil.showToast("BizNotificationHandler 事件：onWatchingShareStatusChanged userId: " + userId + " , status: " + status);
    }

    @Override
    public void onShareVmrInfoNotify(ShareVmrInfo shareVmrInfo) {
        DemoUtil.showToast("BizNotificationHandler 事件：onShareVmrInfoNotify shareVmrInfo， isEnableShareVmr： " + shareVmrInfo.getIsEnableShareVmr());
    }

    @Override
    public void onPairCodeChangedNotify(String pairCode) {

    }

    @Override
    public void onOperateExternalAttendeeNotify(OperateExternalInviteeInfo operateExternalInviteeInfo) {
        DemoUtil.showToast("BizNotificationHandler 事件：onOperateExternalAttendeeNotify type "
            + operateExternalInviteeInfo.getType() );
    }

    @Override
    public void onAddAttendeeNotify(AddAttendeeResultList resultList) {
        if (resultList != null) {
            DemoUtil.showToast("BizNotificationHandler 事件：onAddAttendeeNotify:" + GsonUtil.toJson(resultList));
        }
    }

    @Override
    public void OnCallAllExternalAttendeesNotify(HwmCallAllExternalAttendeesInfo hwmCallAllExternalAttendeesInfo) {
        if (hwmCallAllExternalAttendeesInfo != null) {
            DemoUtil.showToast("BizNotificationHandler 事件：OnCallAllExternalAttendeesNotify size:" + hwmCallAllExternalAttendeesInfo.getInviteeCount());
        }
    }

    @Override
    public void onSelfRoleChangedNotify(ConfRole confRole) {
        if (confRole != null) {
            DemoUtil.showToast("BizNotificationHandler 事件: onSelfRoleChangedNotify, confRole : " + confRole);
        }
    }

    @Override
    public void onWaitingRoomStateChanged(boolean isOpen) {
        DemoUtil.showToast("onWaitingRoomStateChanged, isOpen = " + isOpen);
    }

    @Override
    public void onSubtitleStateChanged(boolean isOpen) {
        DemoUtil.showToast("onSubtitleStateChanged, isOpen = " + isOpen);
    }

    @Override
    public void onCorpConfigNotify(HWMCorpConfigInfo corpConfigInfo) {
        if (corpConfigInfo != null) {
            DemoUtil.showToast("BizNotificationHandler 事件: onCorpConfigNotify pstn : " + corpConfigInfo.isEnablePstn()
                    + " , record : " + corpConfigInfo.isEnableRecord() + " , summary : " + corpConfigInfo.isCorpEnableSummary());
        }
    }

    @Override
    public void OnUserCorpInfoNotify(UserCorpInfoNotifyType type) {
        DemoUtil.showToast("OnUserCorpInfoNotify, UserCorpInfoNotifyType = " + type);
    }

    @Override
    public void onRealTimeSubtitleInfoNotify(RealTimeSubtitle realTimeSubtitle) {
        if (realTimeSubtitle != null) {
            HCLog.i(TAG, "OnRealTimeSubtitleInfoNotify");
            DemoUtil.addConsoleLog("<<realTimeSubtitle>>" + " name : " + SecurityUtils.maskName(realTimeSubtitle.getName()) +
                    ", originalMsg : " + realTimeSubtitle.getOriginalMsg() +
                    ", translatedMsg : " + realTimeSubtitle.getTranslatedMsg());
        }
    }

    @Override
    public void onSubtitleRecordNotify(SubtitleRecordInfo subtitleRecordInfo) {
        if (subtitleRecordInfo != null) {
            HCLog.i(TAG, "OnSubtitleRecordNotify");
            DemoUtil.addConsoleLog("<<subtitleRecordInfo>>" + " name : " + SecurityUtils.maskName(subtitleRecordInfo.getRealTimeSubtitle().getName()) +
                    ", originalMsg : " + subtitleRecordInfo.getRealTimeSubtitle().getOriginalMsg() +
                    ", translatedMsg : " + subtitleRecordInfo.getRealTimeSubtitle().getTranslatedMsg());
        }
    }

    @Override
    public void onLoginStateChangeNotify(LoginState loginState) {
        DemoUtil.showToast("onLoginStateChangeNotify, loginState = " + loginState.getDescription());
    }
}
