package com.huawei.hwmdemo.dependency;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.presentation.dependency.inmeeting.BuildInMenuType;
import com.huawei.hwmconf.presentation.dependency.inmeeting.IConfTitleBarPopwindowHandle;
import com.huawei.hwmconf.presentation.dependency.inmeeting.IMenuAction;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;

public class CustomConfTitleBarPopwindowHandle implements IConfTitleBarPopwindowHandle {

    private static final String VIEW1_TAG = "view1Tag";
    private static final String VIEW2_TAG = "view2Tag";

    @Override
    public void buildConfTitleBarPopwindow(IMenuAction iMenuAction) {
        try {
            View view1 = LayoutInflater.from(DemoUtil.getApplication()).inflate(R.layout.conf_title_bar_item1, null);
            View view2 = LayoutInflater.from(DemoUtil.getApplication()).inflate(R.layout.conf_title_bar_item2, null);
            view1.setTag(VIEW1_TAG);
            view2.setTag(VIEW2_TAG);
            boolean view1Added = false;
            boolean view2Added = false;
            if (iMenuAction instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup) iMenuAction;
                for (int i = 0; i < parent.getChildCount(); i++) {
                    View child = parent.getChildAt(i);
                    if (VIEW1_TAG.equals(child.getTag())) {
                        // 防止重复添加
                        view1Added = true;
                        continue;
                    }
                    if (VIEW2_TAG.equals(child.getTag())) {
                        view2Added = true;
                        continue;
                    }
                }
            }
            if (!view1Added) {
                iMenuAction.addView(view1, 1);
            }
            if (!view2Added) {
                iMenuAction.addView(view2);
            }
        } catch (RuntimeException e) {
            Log.e("addView", e.toString());
        }
        if (!HWMBizSdk.getBizOpenApi().isSelfChairMan()) {
            View mPwdView = iMenuAction.findView(BuildInMenuType.CONF_TITLE_PWD_LAYOUT);
            if (mPwdView != null) {
                mPwdView.setVisibility(View.GONE);
            }
        } else {
            //如果自己是主席，显示密码view
            View mPwdView = iMenuAction.findView(BuildInMenuType.CONF_TITLE_PWD_LAYOUT);
            if (mPwdView != null) {
                mPwdView.setVisibility(View.VISIBLE);
            }
        }
    }
}
