package com.huawei.hwmdemo.dependency;

import com.huawei.hwmconf.sdk.dependency.IUiCustomTextHandler;
import com.huawei.hwmconf.sdk.model.conf.entity.HWMUiCustomTextScene;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.HashMap;
import java.util.Map;

public class CustomIUiCustomTextHandler implements IUiCustomTextHandler {
    @Override
    public String getString(HWMUiCustomTextScene scene) {
        Map<HWMUiCustomTextScene, String> customTextMap = new HashMap<>();
        customTextMap.put(HWMUiCustomTextScene.CLOUD_RECORD_FINISHED_ALERT_TEXT_SCENE,
                DemoUtil.getResContext().getString(R.string.conf_cloud_record_finished_alert_text));
        customTextMap.put(HWMUiCustomTextScene.CLOUD_RECORD_FINISHED_ALERT_TEXT_IN_MEETING_SCENE,
                DemoUtil.getResContext().getString(R.string.conf_cloud_record_finished_alert_text_in_meeting));
        customTextMap.put(HWMUiCustomTextScene.LEAVE_OR_END_CONF_POPUP_WINDOW_TEXT_SCENE,
                DemoUtil.getResContext().getString(R.string.leave_or_end_conf_popup_window_text_scene));
        customTextMap.put(HWMUiCustomTextScene.CLOUD_RECORD_MENU_TITLE_TEXT_SCENE,
                DemoUtil.getResContext().getString(R.string.cloud_record_menu_title_text_scene));
        customTextMap.put(HWMUiCustomTextScene.MAIN_WINDOW_CLOUD_RECORD_DES_TEXT_SCENE,
                DemoUtil.getResContext().getString(R.string.main_window_cloud_record_des_text_scene));
        String value = customTextMap.get(scene);
        return value != null ? value : "";
    }
}
