package com.huawei.hwmdemo.dependency;

import android.util.Log;

import androidx.fragment.app.FragmentActivity;

import com.huawei.hwmconf.presentation.dependency.IParticipantCallOtherNumberStrategy;
import com.huawei.hwmconf.presentation.model.PhoneMenuItem;
import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.sdk.CallOtherNumberSettingFragment;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmfoundation.utils.route.HCActivityManager;

import java.util.ArrayList;
import java.util.List;

/**
 * 自定义与会者页面列表“呼叫其他号码”选项策略
 */
public class CustomParticipantCallOtherNumbers implements IParticipantCallOtherNumberStrategy {

    @Override
    public void buildCallOtherNumberList(AttendeeModel attendeeInfo, HwmCallback<List<PhoneMenuItem>> callback) {
        queryUserPhoneNumbers(attendeeInfo, new HwmCallback<List<String>>() {
            @Override
            public void onFailed(int retCode, String desc) {
                callback.onFailed(retCode, desc);
            }

            @Override
            public void onSuccess(List<String> numbers) {
                List<PhoneMenuItem> phoneMenuItems = new ArrayList<>();
                for (String number : numbers) {
                    PhoneMenuItem phoneMenuItem = new PhoneMenuItem();
                    phoneMenuItem.setNumber(number);
                    phoneMenuItem.setOnClickListener(new PhoneMenuItem.OnClickListener() {
                        @Override
                        public void onClickItem(AttendeeModel attendeeInfo) {
                            DemoUtil.showToast("点击呼叫其他号码：" + attendeeInfo.getNumber());
                        }
                    });
                    phoneMenuItems.add(phoneMenuItem);
                }
                callback.onSuccess(phoneMenuItems);
            }
        });
    }

    private void queryUserPhoneNumbers(AttendeeModel attendeeInfo, HwmCallback<List<String>> callback) {
        try {
            CallOtherNumberSettingFragment dialogFragment = new CallOtherNumberSettingFragment(attendeeInfo, callback);
            dialogFragment.show((FragmentActivity) HCActivityManager.getInstance().getCurActivity());
        } catch (Exception e) {
            Log.e("queryUserPhoneNumbers error:", e.getMessage());
        }
    }
}
