package com.huawei.hwmdemo.dependency;

import android.util.Log;

import com.huawei.hwmbiz.IPushExternalVideoFrameStrategy;
import com.huawei.hwmdemo.view.sdk.IPushVideoFrameNotification;

import java.util.concurrent.CopyOnWriteArrayList;


public class CustomPushExternalVideoFrameStrategy implements IPushExternalVideoFrameStrategy {

    private static CopyOnWriteArrayList<IPushVideoFrameNotification> pushVideoFrameNotifications = new CopyOnWriteArrayList<>();

    public static void registerPushVideoFrameListener(IPushVideoFrameNotification confResultNotification) {
        pushVideoFrameNotifications.add(confResultNotification);
    }

    public static void removePushVideoFrameListener(IPushVideoFrameNotification confResultNotification) {
        pushVideoFrameNotifications.remove(confResultNotification);
    }

    @Override
    public void onSetLocalVideoMirrorTypeNotify() {
        for (IPushVideoFrameNotification listener : pushVideoFrameNotifications) {
            try {
                listener.onSetLocalMirrorNotify();
            } catch (RuntimeException e) {
                Log.e("onSetLocalMirrorNotify", e.toString());
            }
        }
    }

    @Override
    public void onStartPushExternalVideoFrameNotify() {
        for (IPushVideoFrameNotification listener : pushVideoFrameNotifications) {
            try {
                listener.onPushVideoFrameStarted();
            } catch (RuntimeException e) {
                Log.e("onPushVideoFrameStarted", e.toString());
            }
        }
    }

    @Override
    public void onEndPushExternalVideoFrameNotify() {
        for (IPushVideoFrameNotification listener : pushVideoFrameNotifications) {
            try {
                listener.onPushVideoFrameEnded();
            } catch (RuntimeException e) {
                Log.e("onPushVideoFrameEnded", e.toString());
            }
        }
    }
}
