package com.huawei.hwmdemo.dependency;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;


import com.huawei.hwmbiz.contact.dependency.IQueryContactAvatarStrategy;
import com.huawei.hwmconf.sdk.model.conf.entity.ContactInfo;
import com.huawei.hwmdemo.R;
import com.huawei.hwmfoundation.utils.StringUtil;
import com.huawei.hwmlogger.HCLog;

public class CustomQueryContactInfoStrategy implements IQueryContactAvatarStrategy {
    private static final String TAG = CustomQueryContactInfoStrategy.class.getSimpleName();
    private Resources resources;

    public CustomQueryContactInfoStrategy(Resources resources) {
        this.resources = resources;
    }

    @Override
    public Bitmap queryContactAvatar(ContactInfo contactInfo) {
        String extendedField = contactInfo.getExtendedField();
        HCLog.i(TAG, "setQueryContactInfoStrategy account: " + StringUtil.formatString(contactInfo.getAccount())
            + " thirdUserId: " + StringUtil.formatString(contactInfo.getThirdUserId())
            + " sipNumber: " + StringUtil.formatString(contactInfo.getSipNumber())
            + " orgId: " + contactInfo.getOrgId()
            + " extendedField: " + StringUtil.formatString(extendedField)
            + " realNameAccount : " + StringUtil.formatName(contactInfo.getRealNameAccount()));
        // 第三方查询通讯录，返回对应用户的头像图片，这里返回一张默认图片作为示例代码
        return BitmapFactory.decodeResource(resources, R.mipmap.ic_launcher);
    }

}
