package com.huawei.hwmdemo.dependency;

import android.content.Context;
import android.text.TextUtils;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmcommonui.ui.dependency.IShareModel;
import com.huawei.hwmcommonui.utils.DateUtil;
import com.huawei.hwmcommonui.utils.ShareUtil;
import com.huawei.hwmconf.presentation.dependency.share.IShareHandle;
import com.huawei.hwmconf.presentation.dependency.share.model.CopyShareModel;
import com.huawei.hwmconf.presentation.dependency.share.model.ShareTypeEnum;
import com.huawei.hwmconf.presentation.dependency.share.model.SmsShareModel;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfInfo;
import com.huawei.hwmconf.sdk.util.BaseDateUtil;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.ArrayList;
import java.util.List;

//自定义分享菜单
public class CustomShareHandle implements IShareHandle {

    @Override
    public List<IShareModel> buildShareItems(Context context, ConfInfo confInfo, ShareTypeEnum shareTypeEnum) {
        String subject = confInfo.getConfSubject();
        String guestUrl = confInfo.getConfGuestUri();

        String startTime = BaseDateUtil.timeStamp2GMTDate(confInfo.getConfStartTimeStamp(), BaseDateUtil.FMT_YMDHM);
        String endTime = BaseDateUtil.timeStamp2GMTDate(confInfo.getConfEndTimeStamp(), BaseDateUtil.FMT_YMDHM);

        String time = DateUtil.getDateTimeStringForUi(startTime, endTime);

        String chairman = confInfo.getConfScheduserName();
        String confId = confInfo.getConfId();
        String guestPwd = TextUtils.isEmpty(confInfo.getConfPwd()) ? DemoUtil.getResContext().getString(R.string.hwmconf_no_pwd) : confInfo.getConfPwd();
        String content = String.format(DemoUtil.getResContext().getString(R.string.hwmconf_share_content), subject, time, chairman, confId, guestPwd, guestUrl);
        SmsShareModel smsShareModel = new SmsShareModel();
        smsShareModel.setContent(content);
        CopyShareModel copyShareModel = new CopyShareModel();
        copyShareModel.setContent(content);
        List<IShareModel> shareModels = new ArrayList<>();
        if (HWMBizSdk.getPublicConfigApi().isChinaSite() && ShareUtil.isSMSAvailable(context)) {
            shareModels.add(smsShareModel);
        }
        shareModels.add(copyShareModel);
        return shareModels;
    }
}
