package com.huawei.hwmdemo.dependency;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.DisplayMetrics;

import com.huawei.hwmconf.presentation.dependency.IWatermarkHandle;
import com.huawei.hwmconf.presentation.model.HWMWatermarkControlOption;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.constant.ConfigConstant;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmfoundation.utils.PreferenceUtils;
import com.huawei.hwmsdk.enums.WaterMarkEnableType;

/**
 * 功能描述
 *
 * @author l30003719
 * @since 2021-02-20
 */
public class CustomWatermarkHandle implements IWatermarkHandle {
    @Override
    public Bitmap getWatermarkBitMap(Activity curActivity) {
        Bitmap bitmap = BitmapFactory.decodeResource(curActivity.getResources(), R.drawable.watermark);
        // 获取屏幕尺寸
        DisplayMetrics displayMetrics = curActivity.getResources().getDisplayMetrics();
        int screenWidth = displayMetrics.widthPixels;
        int screenHeight = displayMetrics.heightPixels;
        int desiredSize = Math.max(screenWidth, screenHeight);
        // 按屏幕尺寸最大边缩放 Bitmap
        bitmap = Bitmap.createScaledBitmap(bitmap, desiredSize, desiredSize, true);
        return bitmap;
    }

    @Override
    public void onConfWaterMarkEnableChanged(WaterMarkEnableType waterMark) {
        if (waterMark == WaterMarkEnableType.WATER_MARK_ENABLE_TYPE_ON || waterMark == WaterMarkEnableType.WATER_MARK_ENABLE_TYPE_FORCED_ON) {
            DemoUtil.showToast("会中水印开启");
        } else if (waterMark == WaterMarkEnableType.WATER_MARK_ENABLE_TYPE_OFF) {
            DemoUtil.showToast("会中水印关闭");
        }
    }

    @Override
    public HWMWatermarkControlOption getWatermarkControlOption() {
        int controlOption = PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, ConfigConstant.KEY_CUSTOM_WATER_MARK_CONTROL_OPTION_KEY,
                HWMWatermarkControlOption.HWMWatermarkControlOptionNormal.getType(), DemoUtil.getApplication());
        return HWMWatermarkControlOption.valueOf(controlOption);
    }

}
