package com.huawei.hwmdemo.dependency.menu.toolbar.wrapper;

import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IAudienceMenuStrategy;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.ArrayList;
import java.util.List;

public abstract class CustomAudienceMenuStrategyWrapper implements IAudienceMenuStrategy {

    protected IAudienceMenuStrategy handle;


    @Override
    public List<IConfMenu> buildAudienceItemMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        if (handle == null) {
            return confMenus;
        }
        List<IConfMenu> originMenus = handle.buildAudienceItemMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildAudienceItemMenuItems", confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }
}
