package com.huawei.hwmdemo.dependency.menu.toolbar.wrapper;

import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IParticipantMenuStrategy;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.ArrayList;
import java.util.List;

public class CustomParticipantMenuStrategyWrapper implements IParticipantMenuStrategy {

    protected IParticipantMenuStrategy handle;

    @Override
    public List<IConfMenu> buildParticipantMoreMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        List<IConfMenu> originMenus = handle.buildParticipantMoreMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildParticipantMoreMenuItems", confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildParticipantItemMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        List<IConfMenu> originMenus = handle.buildParticipantItemMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildParticipantItemMenuItems", confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildParticipantToolbarMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        List<IConfMenu> originMenus = handle.buildParticipantToolbarMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildParticipantToolbarMenuItems", confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildWaitingToolbarMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        List<IConfMenu> originMenus = handle.buildWaitingToolbarMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildWaitingToolbarMenuItems", confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildUnJoinedToolbarMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        List<IConfMenu> originMenus = handle.buildUnJoinedToolbarMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildUnJoinedToolbarMenuItems", confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildParticipantToolbarMoreMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        List<IConfMenu> originMenus = handle.buildParticipantToolbarMoreMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildParticipantToolbarMoreMenuItems", confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }
}
