package com.huawei.hwmdemo.externalframe;

import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.util.Log;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.sdk.model.conf.entity.DisplayRotation;
import com.huawei.hwmconf.sdk.model.conf.entity.VideoFrameFormat;
import com.huawei.hwmconf.sdk.model.conf.entity.VideoFrameParam;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmlogger.HCLog;

/**
 * 单独的任务类。继承AsyncTask，来处理从相机实时获取的耗时操作
 */
public class FaceTask extends AsyncTask {
    private static final String TAG = FaceTask.class.getSimpleName();
    private byte[] mData;
    private Camera.Parameters mParameters;

    //构造函数
    FaceTask(byte[] data, Camera.Parameters parameters) {
        this.mData = data;
        this.mParameters = parameters;
    }

    @Override
    protected Object doInBackground(Object[] params) {
        if (mParameters == null) {
            HCLog.e(TAG, " parameters is null. ");
            return null;
        }
        int imageFormat = mParameters.getPreviewFormat();
        VideoFrameParam videoFrameParam = new VideoFrameParam();
        videoFrameParam.setFrameDate(mData);
        Camera.Size previewSize = mParameters.getPreviewSize();
        if (previewSize != null) {
            videoFrameParam.setFrameWidth(previewSize.width);
            videoFrameParam.setFrameHeight(previewSize.height);
        }
        videoFrameParam.setDisplayRotation(switchDisplayRotation(PushExternalFrameFlowWindow.getCurOriginalOrientation()));
        videoFrameParam.setVideoFrameFormat(switchImageFormat(imageFormat));
        HWMBizSdk.getBizOpenApi().pushExternalVideoFrame(videoFrameParam, new HwmCallback<Void>() {
            @Override
            public void onSuccess(Void aVoid) {

            }

            @Override
            public void onFailed(int retCode, String desc) {
                Log.i(TAG, "code: " + retCode);
            }
        });
        return null;
    }

    private DisplayRotation switchDisplayRotation(int displayRotation) {
        DisplayRotation rotation = DisplayRotation.ROTATION_0;
        switch (displayRotation) {
            case 0:
                rotation = DisplayRotation.ROTATION_0;
                break;
            case 1:
                rotation = DisplayRotation.ROTATION_90;
                break;
            case 2:
                rotation = DisplayRotation.ROTATION_180;
                break;
            case 3:
                rotation = DisplayRotation.ROTATION_270;
                break;
            default:
                break;
        }
        return rotation;
    }

    private VideoFrameFormat switchImageFormat(int imageFormat) {
        VideoFrameFormat format = VideoFrameFormat.VIDEO_FRAME_FORMAT_UNKNOWN;
        switch (imageFormat) {
            case ImageFormat.YUV_420_888:
                format = VideoFrameFormat.VIDEO_FRAME_FORMAT_I420;
                break;
            case ImageFormat.NV21:
                format = VideoFrameFormat.VIDEO_FRAME_FORMAT_NV21;
                break;
            case ImageFormat.YV12:
                format = VideoFrameFormat.VIDEO_FRAME_FORMAT_YV12;
                break;
            case ImageFormat.UNKNOWN:
                format = VideoFrameFormat.VIDEO_FRAME_FORMAT_UNKNOWN;
                break;
            default:
                Log.i(TAG, "Current Preview Format is default : UNKNOWN");
                break;
        }
        return format;
    }
}
