package com.huawei.hwmdemo.utils;

import android.content.Context;
import android.content.Intent;

import com.huawei.hwmbiz.login.cache.LoginSettingCache;
import com.huawei.hwmdemo.view.webview.WebViewActivity;
import com.huawei.hwmfoundation.utils.DeviceUtil;
import com.huawei.hwmfoundation.utils.FileUtil;

public class ControllerUtils {
    public static void goRouteControllerH5Page(Context context, String nonce, String code,
                                               boolean isOfflinePair) {
        LoginSettingCache.getInstance(DemoUtil.getApplication()).getCacheDataAsyncBlock()
                .subscribe(loginSetting -> {
                    StringBuilder stringBuilder = new StringBuilder("https://");
                    stringBuilder.append(loginSetting.getServerAddress())
                            .append(":")
                            .append(loginSetting.getServerPort())
                            .append("/hcp/#/controller/auth?language=zh-CN")
                            .append("&nonce=").append(nonce)
                            .append("&code=").append(code);
                    String deviceId = FileUtil.encryptSHA256(
                            DeviceUtil.getAndroidId(DemoUtil.getApplication()).getBytes()
                    );
                    if (isOfflinePair) {
                        stringBuilder.append("&deviceName=").append(DeviceUtil.getDeviceName(DemoUtil.getApplication()))
                                .append("&deviceId=").append(deviceId);
                    }

                    Intent intent = new Intent(context, WebViewActivity.class);
                    intent.putExtra("requestUrl", stringBuilder.toString());
                    context.startActivity(intent);
                });
    }
}
