package com.huawei.hwmdemo.utils;

import com.huawei.hwmsdk.enums.SDKERR;

import java.util.HashMap;
import java.util.Map;

public class ErrorMessageFactory {

    private static final Map<Integer, String> ERROR_MAP = new HashMap<Integer, String>() {
        {
            put(SDKERR.SDK_LOGIN_E_ERR_MNG_FAILED.getValue(), "服务器降级，接入方收到该错误码可以继续调用入会接口离线入会");
        }
    };

    private ErrorMessageFactory() {
    }

    public static String create(int errorCode, String defaultErrorMsg) {
        if (ERROR_MAP.containsKey(errorCode)) {
            return ERROR_MAP.get(errorCode);
        }
        return defaultErrorMsg;
    }
}
