/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2012-2019. All rights reserved.
 */

package com.huawei.hwmdemo.utils;

import android.content.Context;
import android.content.SharedPreferences;


public class PreferencesUtil {
    private static final int MODE = Context.MODE_PRIVATE;
    private static final String FILENAME = "config_file";


    private PreferencesUtil() {
    }

    /**
     * 用SharedPreferences存储一个键值到xml
     *
     * @param context    上下文
     * @param key        键
     * @param value      值
     */
    public static void setStringPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(FILENAME, MODE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static void asyncSave(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(FILENAME, MODE);
        if (sharedPreferences != null) {
            SharedPreferences.Editor edit = sharedPreferences.edit();
            edit.putString(key, value);
            edit.apply();
        }
    }


    /**
     * 取String值
     *
     * @param context      上下文
     * @param key          键值
     * @param defaultValue 默认值
     * @return 查询到的值
     */
    public static String getStringPreference(Context context, String key, String defaultValue) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(FILENAME, MODE);
        return sharedPreferences.getString(key, defaultValue);
    }

    /**
     * 用SharedPreferences存储一个键值(int)到xml
     *
     * @param context    上下文
     * @param key        键
     * @param value      值
     */
    public static void setIntPreference(Context context, String key, int value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(FILENAME, MODE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    /**
     * 用SharedPreferences存储一个键值(int)到xml
     *
     * @param context    上下文
     * @param key        键
     */
    public static int getIntPreference(Context context, String key, int defaultValue) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(FILENAME, MODE);
        return sharedPreferences.getInt(key, defaultValue);
    }

}
