
package com.huawei.hwmdemo.view.sdk;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.huawei.conflogic.HwmAttendeeType;
import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmbiz.contact.cache.MyInfoCache;
import com.huawei.hwmbiz.login.cache.LoginStatusCache;
import com.huawei.hwmconf.presentation.ConfUI;
import com.huawei.hwmconf.presentation.error.ErrorMessageFactory;
import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmconf.sdk.model.conf.entity.BookConfParam;
import com.huawei.hwmconf.sdk.model.conf.entity.BookCycleConfParam;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfRole;
import com.huawei.hwmconf.sdk.model.conf.entity.JoinConfPermissionType;
import com.huawei.hwmconf.sdk.model.conf.entity.MeetingType;
import com.huawei.hwmconf.sdk.model.conf.entity.VmrIdType;
import com.huawei.hwmconf.sdk.model.conf.entity.VmrInfoListModel;
import com.huawei.hwmconf.sdk.model.conf.entity.VmrInfoModel;
import com.huawei.hwmconf.sdk.util.BaseDateUtil;
import com.huawei.hwmconf.sdk.util.Utils;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.Foundation;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmfoundation.utils.LanguageUtil;
import com.huawei.hwmfoundation.utils.StringUtil;
import com.huawei.hwmlogger.HCLog;
import com.huawei.hwmsdk.enums.AutoMuteType;
import com.huawei.hwmsdk.enums.ConfResType;
import com.huawei.hwmsdk.enums.CycleType;
import com.huawei.hwmsdk.enums.SDKERR;
import com.huawei.hwmsdk.model.param.CycleConfParam;
import com.huawei.hwmsdk.model.result.AppIdAuthInfo;

import org.jetbrains.annotations.NotNull;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;

/**
 * 预约周期会议 - 使用Native SDK接口实现
 *
 * @since 2021-10-21
 * @author wuyusheng
 */
public class BookCycleMeetingFragment extends BaseDialogFragment {
    private static final String TAG = BookCycleMeetingFragment.class.getSimpleName();

    private View mRootView;

    private List<VmrInfoModel> mVmrList = new ArrayList<>();

    private VmrInfoModel mVmrInfoModel = new VmrInfoModel();

    // 共享云会议室是否可用
    private boolean isEnableShareVmr = false;

    private Switch mAutoInviteSwitch;

    private CycleType mSelectedCycleType;

    private List<AttendeeModel> mAttendeeInfoList = new ArrayList<>();

    private Context mContext;

    private boolean mIsNeedPassword;

    private boolean mIsNeedRecord;

    private boolean mIsAutoStartRecord;

    private boolean mIsNeedEmail;

    private boolean mNeedSms;

    private boolean mIsNeedEmailCalendar;

    private boolean mIsNeedWithMember;

    private JoinConfPermissionType joinConfPermissionType = JoinConfPermissionType.PERMIT_EVERYONE;

    private EditText customMsg;

    private EditText maxNumber;

    private Switch personalIdSwitch;

    private Switch shareVmrSwitch;

    private EditText vmrIdText;

    // 来宾入会，软终端自动静音模式
    private AutoMuteType autoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_DEFAULT;

    // 来宾入会，硬终端自动静音模式
    private AutoMuteType hardTerminalAutoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_DEFAULT;

    private Switch forbiddenScreenShots;

    private Switch openWatermark;

    // 与会者列表是否去掉预定者
    private Switch attendeesExcludeSelf;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        mRootView = inflater.inflate(R.layout.sdk_book_cycle_conf, container, false);

        Button createBtn = mRootView.findViewById(R.id.book_conf);
        createBtn.setOnClickListener(v -> bookConf());
        initCycleConfView();

        mAutoInviteSwitch = mRootView.findViewById(R.id.switch_auto_invite);
        mAutoInviteSwitch.setChecked(true);

        personalIdSwitch = mRootView.findViewById(R.id.switch_is_use_personnal_id);
        personalIdSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                shareVmrSwitch.setEnabled(!isChecked);
                if (isChecked) {
                    if (!mVmrList.isEmpty()) {
                        mVmrInfoModel = mVmrList.get(0);
                        vmrIdText.setText(mVmrInfoModel.getVmrConferenceId());
                    }
                    vmrIdText.setVisibility(View.VISIBLE);
                } else {
                    vmrIdText.setVisibility(View.GONE);
                }
            }
        });
        forbiddenScreenShots = mRootView.findViewById(R.id.book_cycle_conf_forbid_screen_shot);
        openWatermark = mRootView.findViewById(R.id.book_cycle_conf_open_watermark);
        attendeesExcludeSelf = mRootView.findViewById(R.id.attendees_exclude_self);

        vmrIdText = mRootView.findViewById(R.id.book_vmrid);
        handleShareVmr();
        Switch attendChooseSwitch = mRootView.findViewById(R.id.book_switch_with_attend);
        attendChooseSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                showChooseAttend(isChecked);
            }
        });
        View attendView = mRootView.findViewById(R.id.book_attend_view);
        attendView.setVisibility(attendChooseSwitch.isChecked() ? View.VISIBLE : View.GONE);

        if (HWMBizSdk.getBizOpenApi().hasBookConfSmsPermission()) {
            mRootView.findViewById(R.id.switch_send_sms).setVisibility(View.VISIBLE);
        } else {
            mRootView.findViewById(R.id.switch_send_sms).setVisibility(View.GONE);
        }

        TextView startTimeView = mRootView.findViewById(R.id.book_start_time);
        Date startTimeDate = BaseDateUtil.getDefaultStartTime();
        String defaultTime = BaseDateUtil.convertDateToString(startTimeDate, BaseDateUtil.FMT_YMDHMS);
        startTimeView.setText(defaultTime);

        Timer timer = new Timer();
        timer.schedule(new MyTimerTask(), 50);

        RadioGroup modeGroup = mRootView.findViewById(R.id.allow_group);
        ((RadioButton) mRootView.findViewById(R.id.allow_mode_everyone)).setChecked(true);
        modeGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.allow_mode_everyone) {
                    joinConfPermissionType = JoinConfPermissionType.PERMIT_EVERYONE;
                } else if (id == R.id.allow_mode_enterprise) {
                    joinConfPermissionType = JoinConfPermissionType.PERMIT_ENTERPRISE_USER;
                } else {
                    joinConfPermissionType = JoinConfPermissionType.PERMIT_INVITED_USER;
                }
            }
        });
        addSelfAsAttendee();
        handleAutoMute();
        return mRootView;
    }

    private void initCycleConfView() {
        Spinner cycleTypeSpinner = mRootView.findViewById(R.id.cycle_type_spinner);

        List<String> cycleTypeList = new ArrayList<>();
        cycleTypeList.add("daily");
        cycleTypeList.add("weekly");
        cycleTypeList.add("monthly");
        ArrayAdapter<String> typeAdapter = new ArrayAdapter<>(mContext, R.layout.main_spinner_item, cycleTypeList);
        typeAdapter.setDropDownViewResource(R.layout.support_simple_spinner_dropdown_item);
        cycleTypeSpinner.setAdapter(typeAdapter);
        cycleTypeSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                if (position == 0) {
                    mSelectedCycleType = CycleType.CYCLE_TYPE_DAY;
                } else if (position == 1) {
                    mSelectedCycleType = CycleType.CYCLE_TYPE_WEEK;
                } else if (position == 2) {
                    mSelectedCycleType = CycleType.CYCLE_TYPE_MONTH;
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
    }

    class MyTimerTask extends TimerTask {

        @Override
        public void run() {
            HWMBizSdk.getBizOpenApi().getVmrInfoList(new HwmCallback<VmrInfoListModel>() {
                @Override
                public void onSuccess(VmrInfoListModel vmrInfoListModel) {
                    mVmrList = vmrInfoListModel.getVmrInfoList();
                    Log.i(TAG, "getVmrList: " + (mVmrList.size()));
                    isEnableShareVmr = vmrInfoListModel.isEnableShareVmr();
                    if (shareVmrSwitch != null) {
                        if (shareVmrSwitch.isChecked()) {
                            shareVmrSwitch.setChecked(isEnableShareVmr);
                        }
                        shareVmrSwitch.setEnabled(isEnableShareVmr);
                    }
                }
                @Override
                public void onFailed(int retCode, String desc) {
                    HCLog.i(TAG,"getVmrList onFailed" + retCode + " " + desc);
                }
            });
        }
    }

    private void handleShareVmr() {
        shareVmrSwitch = mRootView.findViewById(R.id.switch_is_use_share_vmr);
        shareVmrSwitch.setEnabled(isEnableShareVmr);
        shareVmrSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                personalIdSwitch.setEnabled(!isChecked);
                vmrIdText.setVisibility(View.GONE);
            }
        });
    }

    private void handleAutoMute() {
        RadioGroup autoMutePersonGroup = mRootView.findViewById(R.id.auto_mute_person_group);
        ((RadioButton)mRootView.findViewById(R.id.auto_mute_person_default)).setChecked(true);
        autoMutePersonGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.auto_mute_person_mute) {
                    autoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_MUTE;
                } else if (id == R.id.auto_mute_person_unmute) {
                    autoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_UNMUTE;
                } else {
                    autoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_DEFAULT;
                }
            }
        });

        RadioGroup autoMuteRoomGroup = mRootView.findViewById(R.id.auto_mute_room_group);
        ((RadioButton)mRootView.findViewById(R.id.auto_mute_room_default)).setChecked(true);
        autoMuteRoomGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.auto_mute_room_mute) {
                    hardTerminalAutoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_MUTE;
                } else if (id == R.id.auto_mute_room_unmute) {
                    hardTerminalAutoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_UNMUTE;
                } else {
                    hardTerminalAutoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_DEFAULT;
                }
            }
        });
    }
    private void bookConf() {
        // 会议主题
        String subject = getSubject();

        // 会议开始时间、时区、会议时长
        TextView startTimeView = mRootView.findViewById(R.id.book_start_time);
        TextView timeZomeView = mRootView.findViewById(R.id.book_time_zone);
        TextView timeDurationView = mRootView.findViewById(R.id.book_duration);
        String startTime = getStartTime(startTimeView.getText().toString());
        long startTimeStamp = BaseDateUtil.dateToTimeStamp(startTime, BaseDateUtil.FMT_YMDHMS);
        String timeZoneStr = timeZomeView.getText().toString();
        if (TextUtils.isEmpty(timeZoneStr)) {
            DemoUtil.showToast("Please fill in the timezone!");
            return;
        }
        int duration = getDuration(timeDurationView);

        RadioButton audioBtn = mRootView.findViewById(R.id.radio_audio);
        Switch needUsePersonalIdSwitch = mRootView.findViewById(R.id.switch_is_use_personnal_id);
        EditText vmrText = mRootView.findViewById(R.id.book_vmrid);
        String vmrConferenceId = vmrText.getText().toString();
        String vmrId = "";
        boolean needUsePersonalId = needUsePersonalIdSwitch.isChecked();
        if (needUsePersonalId) {
            if (StringUtil.isEmpty(vmrConferenceId)) {
                DemoUtil.showToast("vmrId cannot be empty when book conf using personal confId");
                return;
            } else {
                vmrId = findVmrIdByFromList(vmrConferenceId);
            }
        }
        handleSwitchStatus();
        showLoading();

        EditText cycleSubDates = mRootView.findViewById(R.id.cycle_sub_dates_input);
        EditText cycleEndDate = mRootView.findViewById(R.id.cycle_end_date_input);
        EditText cycleInterval = mRootView.findViewById(R.id.cycle_interval_input);
        EditText cyclePreMindDays = mRootView.findViewById(R.id.cycle_premind_days_input);
        String subDates = cycleSubDates.getText().toString();

        int interval = getEditTextStr(cycleInterval);
        Calendar endTime = getEndTime(cycleEndDate);
        int preMindDays = getEditTextStr(cyclePreMindDays);

        CycleConfParam cycleConfParam = new CycleConfParam();
        cycleConfParam.setCycleType(mSelectedCycleType);
        cycleConfParam.setInterval(interval);
        cycleConfParam.setListPoints(subDates);
        cycleConfParam.setStartTimeStamp(startTimeStamp);
        cycleConfParam.setEndTimeStamp(endTime.getTimeInMillis() / 1000);
        cycleConfParam.setPreRemindDays(preMindDays);

        boolean isForbidScreenShot = forbiddenScreenShots.isChecked();
        boolean isOpenWatermark = openWatermark.isChecked();
        boolean isAttendeesExcludeSelf = attendeesExcludeSelf.isChecked();

        HCLog.i(TAG, "book cycle conf");
        BookConfParam bookConfParam = new BookConfParam().setConfSubject(subject)
            .setStartTimeStamp(startTimeStamp)
            .setTimeZone(Integer.parseInt(timeZoneStr))
            .setDuration(duration)
            .setConfType(audioBtn.isChecked() ? MeetingType.CONF_AUDIO : MeetingType.CONF_VIDEO)
            .setVmrIdFlag(needUsePersonalId)
            .setVmrId(vmrId)
            .setNeedConfPwd(mIsNeedPassword)
            .setJoinConfRestrictionType(joinConfPermissionType)
            .setRecordOn(mIsNeedRecord)
            .setAutoRecord(mIsAutoStartRecord)
            .setMailOn(mIsNeedEmail)
            .setSmsOn(mNeedSms)
            .setEmailCalenderOn(mIsNeedEmailCalendar)
            .setAttendees(mAttendeeInfoList)
            .setAllowGuestStartConf(false)
            .setCustomInfo(customMsg.getText().toString())
            .setAutoMuteMode(autoMuteMode)
            .setHardTerminalAutoMuteMode(hardTerminalAutoMuteMode)
            .setForbiddenScreenShots(isForbidScreenShot)
            .setOpenWatermark(isOpenWatermark)
            .setAttendeesExcludeSelf(isAttendeesExcludeSelf);

        if (shareVmrSwitch.isChecked()) {
            bookConfParam.setVmrIdFlag(false)
                    .setVmrIdType(VmrIdType.RANDOM_ID)
                    .setConfResType(ConfResType.CONF_RESTYPE_SHARE_VMR);
        }

        if (!TextUtils.isEmpty(maxNumber.getText().toString())) {
            int maxConcurrent;
            try {
                maxConcurrent = Integer.parseInt(maxNumber.getText().toString());
            } catch (NumberFormatException e) {
                DemoUtil.showToast("会议最大方数格式不正确");
                dismissLoading();
                return;
            }
            bookConfParam.setConcurrentParticipants(maxConcurrent);
        }
        BookCycleConfParam bookCycleConfParam = new BookCycleConfParam();
        bookCycleConfParam.setBookConfParam(bookConfParam);
        bookCycleConfParam.setCycleConfParam(cycleConfParam);
        HWMBizSdk.getBizOpenApi().bookCycleConf(bookCycleConfParam, completeHandler);
    }

    private HwmCallback<ConfInfo> completeHandler = new HwmCallback<ConfInfo>() {
        @Override
        public void onSuccess(ConfInfo result) {
            doDismissDialogAndFragment();
            DemoUtil.showToast("预约周期会议成功");
        }

        @Override
        public void onFailed(int retCode, String desc) {
            doDismissDialogAndFragment();
            String err = ErrorMessageFactory.create(retCode);
            if (!TextUtils.isEmpty(err)) {
                desc = err;
            }
            DemoUtil.showToastDialog("预约周期会议", retCode, desc);
        }
    };

    @NotNull
    private Calendar getEndTime(EditText cycleEndDate) {
        String endDateTxt = cycleEndDate.getText().toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        Calendar endTime = Calendar.getInstance();
        try {
            Date date = sdf.parse(endDateTxt);
            endTime.setTime(date != null ? date : new Date());
        } catch (ParseException e) {
            HCLog.e(TAG, "parse end date failed:" + endDateTxt);
        }
        return endTime;
    }

    private int getEditTextStr(EditText editText) {
        String cycleIntervalTxt = editText.getText().toString();
        int interval = 0;
        if (!TextUtils.isEmpty(cycleIntervalTxt) && TextUtils.isDigitsOnly(cycleIntervalTxt)) {
            interval = Integer.parseInt(cycleIntervalTxt);
        }
        return interval;
    }

    private int getDuration(TextView timeDurationView) {
        int duration = 30;
        String timeDurStr = timeDurationView.getText().toString();
        if (!TextUtils.isEmpty(timeDurStr)) {
            duration = Integer.parseInt(timeDurStr);
        }
        return duration;
    }

    @NotNull
    private String getSubject() {
        TextView subjectView = mRootView.findViewById(R.id.book_subject);
        String subject = subjectView.getText().toString();
        if (TextUtils.isEmpty(subject)) {
            subject = subjectView.getHint().toString();
        }
        return subject;
    }

    private void handleSwitchStatus() {
        Switch needPasswordSwitch = mRootView.findViewById(R.id.book_switch_need_password);
        mIsNeedPassword = needPasswordSwitch.isChecked();

        Switch needRecordSwitch = mRootView.findViewById(R.id.switch_record_conf);
        mIsNeedRecord = needRecordSwitch.isChecked();

        Switch isAutoStartRecordSwitch = mRootView.findViewById(R.id.switch_record_is_auto_start);
        mIsAutoStartRecord = isAutoStartRecordSwitch.isChecked();

        Switch needEmailSwitch = mRootView.findViewById(R.id.switch_send_email);
        mIsNeedEmail = needEmailSwitch.isChecked();

        Switch needSmsSwitch = mRootView.findViewById(R.id.switch_send_sms);
        mNeedSms = needSmsSwitch.isChecked();

        Switch needEmailCalendarSwitch = mRootView.findViewById(R.id.switch_send_email_calandar);
        mIsNeedEmailCalendar = needEmailCalendarSwitch.isChecked();

        Switch needWithMemberSwitch = mRootView.findViewById(R.id.book_switch_with_attend);
        mIsNeedWithMember = needWithMemberSwitch.isChecked();
        processWithAttendee(mIsNeedWithMember);

        customMsg = mRootView.findViewById(R.id.custom_message);
        maxNumber = mRootView.findViewById(R.id.max_num_edit);
    }

    private String getStartTime(String startTimeLocal) {
        String startTime = startTimeLocal;
        if (startTime.isEmpty()) {
            Date startTimeDate = BaseDateUtil.getDefaultStartTime();
            SimpleDateFormat simpleDateFormat =
                new SimpleDateFormat(BaseDateUtil.FMT_YMDHMS, LanguageUtil.getSystemLocale(DemoUtil.getResContext()));
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+08:00"));
            startTime = simpleDateFormat.format(startTimeDate);
        }
        return startTime;
    }

    private void processWithAttendee(boolean needWithMember) {
        if (needWithMember) {
            if (!mAutoInviteSwitch.isChecked()) {
                for (AttendeeModel attendee : mAttendeeInfoList) {
                    attendee.setIsAutoInvite(false);
                }
            }
        }
    }

    private void showChooseAttend(boolean isChecked) {
        if (isChecked) {
            ConfUI.getInstance().getAddAttendees().doAddAttendees(getActivity(), new ArrayList<>(),
                    " ", false, new HwmCallback<List<AttendeeModel>>() {
                        @Override
                        public void onFailed(int retCode, String desc) {
                            if (SDKERR.SDKERR_SUCCESS.getValue() != retCode) {
                                DemoUtil.showToast("添加与会者失败：" + desc);
                            }
                        }

                        @Override
                        public void onSuccess(List<AttendeeModel> attendeeModels) {
                            mAttendeeInfoList = attendeeModels;
                        }
                    });
        }
    }

    private String findVmrIdByFromList(String vmrConferenceId) {
        String vmrId = mVmrInfoModel.getVmrId();
        for (VmrInfoModel vmrInfoModel : mVmrList) {
            if (vmrInfoModel.getVmrConferenceId().equals(vmrConferenceId)) {
                vmrId = vmrInfoModel.getVmrId();
            }
        }
        return vmrId;
    }

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        mContext = context;
    }

    private void addSelfAsAttendee() {
        MyInfoCache.getInstance(Utils.getApp()).getCacheDataAsyncBlock().subscribe(myInfoModel -> {
            AttendeeModel selfAttendee = new AttendeeModel();
            selfAttendee.setAccountId(myInfoModel.getAccount());
            selfAttendee.setEmail(myInfoModel.getEmail());
            selfAttendee.setIsAutoInvite(true);
            selfAttendee.setIsMute(false);
            selfAttendee.setName(myInfoModel.getName());
            selfAttendee.setNumber(myInfoModel.getBindNum());
            selfAttendee.setRole(ConfRole.HOST);
            String mobile = myInfoModel.getMobile();
            selfAttendee.setSms((TextUtils.isEmpty(mobile)) ? "" : mobile);
            selfAttendee.setType(HwmAttendeeType.ATTENDEE_TYPE_NORMAL);
            selfAttendee.setSelf(true);
            if (LoginStatusCache.getsLoginAccountInfo() instanceof AppIdAuthInfo) {
                AppIdAuthInfo appIdAuthInfo = (AppIdAuthInfo) LoginStatusCache.getsLoginAccountInfo();
                selfAttendee.setAppId(Foundation.getAppid());
                selfAttendee.setThirdUserId(appIdAuthInfo.getThirdUserId());
            }
            mAttendeeInfoList.add(selfAttendee);
        }, throwable -> HCLog.e(TAG, throwable.toString()));
    }
}
