package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;

import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmdemo.R;
import com.huawei.hwmfoundation.callback.HwmCallback;

import java.util.ArrayList;
import java.util.List;

public class CallOtherNumberSettingFragment extends DialogFragment {
    private final AttendeeModel attendeeInfo;
    private final HwmCallback<List<String>> callback;
    private boolean callbackSuccess = false;

    public CallOtherNumberSettingFragment(AttendeeModel attendeeInfo, HwmCallback<List<String>> callback) {
        this.attendeeInfo = attendeeInfo;
        this.callback = callback;
    }

    public void show(FragmentActivity fragmentActivity) {
        this.show(fragmentActivity.getSupportFragmentManager(), null);
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        if (getDialog() != null) {
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
            getDialog().setCanceledOnTouchOutside(false);
        }
        View vRoot = inflater.inflate(R.layout.call_other_number_setting_layout, container, false);
        initViews(vRoot);
        return vRoot;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (!callbackSuccess) {
            callback.onFailed(-1, "");
        }
    }

    private void initViews(View vRoot) {
        callbackSuccess = false;
        TextView attendee = vRoot.findViewById(R.id.attendee_name);
        attendee.setText(attendeeInfo.getName());
        Button button = vRoot.findViewById(R.id.set_guaranteed_button);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                callbackSuccess = true;
                callback.onSuccess(findEditTexts(vRoot, new ArrayList<>()));
                CallOtherNumberSettingFragment.this.dismiss();
            }
        });
    }

    private List<String> findEditTexts(View view, List<String> editTexts) {
        if (view instanceof EditText) {
            String number = ((EditText) view).getText().toString();
            if (!TextUtils.isEmpty(number)) {
                editTexts.add(number);
            }
        } else if (view instanceof ViewGroup) {
            ViewGroup ViewGroup = (ViewGroup) view;
            int childCount = ViewGroup.getChildCount();
            for (int i = 0; i < childCount; i++) {
                View child = ViewGroup.getChildAt(i);
                findEditTexts(child, editTexts);
            }
        }
        return editTexts;
    }
}
