package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.CompoundButton;
import android.widget.Switch;

import androidx.annotation.NonNull;

import com.huawei.cloudlink.tup.TupConfig;
import com.huawei.hwmbiz.impl.BizOpenApiImpl;
import com.huawei.hwmconf.presentation.ConfUI;
import com.huawei.hwmconf.sdk.dependency.HWMEnableFeatureType;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmsdk.model.result.SupportCapability;

public class CapabilitiesConfigStateFragment extends BaseDialogFragment {

    private final static String TAG = CapabilitiesConfigStateFragment.class.getSimpleName();

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        View rootView = inflater.inflate(R.layout.sdk_capabilities_config_state, container, false);
        initData();
        initView(rootView);
        return rootView;
    }

    private void initData() {

    }

    private void initView(View rootView) {
        Switch disableBreakoutSwitch = rootView.findViewById(R.id.disable_breakout_feature);
        SupportCapability supportCapability = ConfUI.getSupportCapability();
        boolean isChecked = supportCapability != null && !supportCapability.getIsSupportBreakoutConf();
        disableBreakoutSwitch.setChecked(isChecked);
        disableBreakoutSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_BREAKOUT_CONF, !isChecked);
            }
        });

        Switch enableConfirmRecordSwitch = rootView.findViewById(R.id.enable_confirm_record);
        isChecked = ConfUI.isEnableConfConfirmRecord();
        enableConfirmRecordSwitch.setChecked(isChecked);
        enableConfirmRecordSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_CONFIRM_RECORD, isChecked);
            }
        });

        Switch enableSaveName = rootView.findViewById(R.id.enable_save_name_when_anonymous_join);
        isChecked = ConfUI.isEnableSaveAnonymousNickName();
        enableSaveName.setChecked(isChecked);
        enableSaveName.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_SAVE_NICK_NAME_WHEN_ANONYMOUS_JOIN, isChecked);
            }
        });

        Switch unAllowCustomVrbgByUser = rootView.findViewById(R.id.un_allow_custom_vrbg_by_user);
        isChecked = !ConfUI.isAllowCustomVrbgByUser();
        unAllowCustomVrbgByUser.setChecked(isChecked);
        unAllowCustomVrbgByUser.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_CUSTOM_VIRTUALBG_IMAGE, !isChecked);
            }
        });


        Switch supportDisconnectAudio = rootView.findViewById(R.id.support_disconnect_audio);
        isChecked = ConfUI.isSupportDisconnectAudio();
        supportDisconnectAudio.setChecked(isChecked);
        supportDisconnectAudio.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.HWM_ENABLE_FEATURE_SUPPORT_DISCONNECT_AUDIO, isChecked);
            }
        });

        Switch disableVirtualBackground = rootView.findViewById(R.id.disable_virtual_background);
        isChecked = !TupConfig.isSupportVirtualBackground();
        disableVirtualBackground.setChecked(isChecked);
        disableVirtualBackground.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.HWM_ENABLE_FEATURE_TYPE_VIRTUAL_BACKGROUND, !isChecked);
            }
        });


        Switch hideInviteToast = rootView.findViewById(R.id.hide_invite_toast);
        isChecked = ConfUI.getHideInviteResultToast();
        hideInviteToast.setChecked(isChecked);
        hideInviteToast.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.ENABLE_TYPE_HIDE_INVITE_RESULT_TOAST, isChecked);
            }
        });

        Switch hideOfflineParticipantList = rootView.findViewById(R.id.hide_offline_participant_list);
        isChecked = ConfUI.getHideOfflineParticipantList();
        hideOfflineParticipantList.setChecked(isChecked);
        hideOfflineParticipantList.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.HIDE_OFFLINE_PARTICIPANT_LIST, isChecked);
            }
        });

        Switch hideVBRiskTip = rootView.findViewById(R.id.hide_vb_risk_tip);
        isChecked = ConfUI.getIsHiddenVBRiskTip();
        hideVBRiskTip.setChecked(isChecked);
        hideVBRiskTip.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_HIDE_VB_RISK_TIP, isChecked);
            }
        });

        Switch permissionUseTips = rootView.findViewById(R.id.permission_use_tips);
        isChecked = ConfUI.isPermissionUseTips();
        permissionUseTips.setChecked(isChecked);
        permissionUseTips.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_PERMISSION_USE_TIPS, isChecked);
            }
        });

        Switch confEndHideTips = rootView.findViewById(R.id.conf_end_hide_tips);
        isChecked = ConfUI.isConfEndHideTips();
        confEndHideTips.setChecked(isChecked);
        confEndHideTips.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                BizOpenApiImpl.getInstance(DemoUtil.getApplication()).enableFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_CONF_END_HIDE_TIPS, isChecked);
            }
        });
    }

}
