package com.huawei.hwmdemo.view.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.cloudlink.openapi.api.param.ConfType;
import com.huawei.cloudlink.openapi.api.param.CreateConfParam;
import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmbiz.login.cache.LoginStatusCache;
import com.huawei.hwmconf.presentation.ConfUI;
import com.huawei.hwmconf.presentation.error.ErrorMessageFactory;
import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.JoinConfPermissionType;
import com.huawei.hwmconf.sdk.model.conf.entity.MeetingIdType;
import com.huawei.hwmconf.sdk.model.conf.entity.VmrIdType;
import com.huawei.hwmconf.sdk.model.conf.entity.VmrInfoListModel;
import com.huawei.hwmconf.sdk.model.conf.entity.VmrInfoModel;
import com.huawei.hwmconf.sdk.util.Utils;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.model.ModeType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.DemoActivity;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmdemo.vision.utils.ModeUtil;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmfoundation.callback.HwmCancelableCallBack;
import com.huawei.hwmlogger.HCLog;
import com.huawei.hwmsdk.enums.AutoMuteType;
import com.huawei.hwmsdk.enums.ConfAllowJoinUserType;
import com.huawei.hwmsdk.enums.ConfResType;
import com.huawei.hwmsdk.enums.SDKERR;
import com.huawei.hwmsdk.enums.SummaryState;
import com.huawei.hwmsdk.model.result.DeviceResource;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

@SuppressLint("UseSwitchCompatOrMaterialCode")
public class CreateMeetingFragment extends BaseDialogFragment {
    public final static String TAG = CreateMeetingFragment.class.getSimpleName();
    private View rootView;

    private List<VmrInfoModel> vmrlist = new ArrayList<>();
    private final VmrInfoModel mVmrInfoModel = new VmrInfoModel();
    // 共享云会议室是否可用
    private boolean isEnableShareVmr = false;
    // Rooms每个激活的设备只会绑定唯一云会议室，即vmrId唯一
    private String roomsVmrId;
    // Mobile当前选择的vmrId
    private String mobileSelectedVmrId;
    private Switch personnalIDSwitch;
    private Switch attendChooseSwitch;

    private Switch shareVmrSwitch;
    private RadioGroup modeGroup;
    private JoinConfPermissionType joinConfPermissionType = JoinConfPermissionType.PERMIT_EVERYONE;
    private RadioGroup vmrIdTypeGroup;

    private VmrIdType vmrConfIdType = VmrIdType.RANDOM_ID;

    private Switch useVmrConfSwitch;

    private boolean isUseVmrConf = false;

    private LinearLayout fixIdChosenArea;

    private Spinner vmrIdChosenSpinner;

    private final List<String> vmrConferenceIdList = new ArrayList<>();

    private Switch needPasswordSwitch;

    private LinearLayout guestPwdView;

    private EditText guestPwd;

    private RadioButton allowModeAnyone;

    private RadioButton allowModeEnterprise;

    private RadioButton allowModeInvite;

    private Switch enableWaitingRoomSwitch;

    private EditText customMsg;

    private EditText maxNumber;

    // 来宾入会，软终端自动静音模式
    private AutoMuteType autoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_DEFAULT;

    // 来宾入会，硬终端自动静音模式
    private AutoMuteType hardTerminalAutoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_DEFAULT;

    private Switch openWatermarkSwitch;

    private Switch autoPublishSummarySwitch;

    private List<AttendeeModel> attendeeList;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (getDialog() != null) {
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        }
        rootView = inflater.inflate(R.layout.sdk_create_conf, container, false);

        Button createBtn = rootView.findViewById(R.id.create_conf);
        createBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                createConf(null);
            }
        });

        Button createBtnWithActivity = rootView.findViewById(R.id.create_conf_with_demo_activity);
        createBtnWithActivity.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                createConf(DemoActivity.getInstance());
            }
        });

        enableWaitingRoomSwitch = rootView.findViewById(R.id.switch_open_waiting_room);
        openWatermarkSwitch = rootView.findViewById(R.id.open_watermark_switch);
        openWatermarkSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if (openWatermarkSwitch != null) {
                    openWatermarkSwitch.setChecked(b);
                }
            }
        });
        attendChooseSwitch = rootView.findViewById(R.id.switch_with_attend);
        attendChooseSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                showChooseAttend(isChecked);
            }
        });

        Timer timer = new Timer();
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                if (ModeUtil.getModeType(DemoUtil.getApplication()) == ModeType.MOBILE) {
                    getVmrInfoList();
                } else {
                    getDeviceResource();
                }
            }
        }, 50);

        modeGroup = rootView.findViewById(R.id.allow_group);
        ((RadioButton)rootView.findViewById(R.id.allow_mode_everyone)).setChecked(true);
        modeGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.allow_mode_everyone) {
                    joinConfPermissionType = JoinConfPermissionType.PERMIT_EVERYONE;
                } else if (id == R.id.allow_mode_enterprise) {
                    joinConfPermissionType = JoinConfPermissionType.PERMIT_ENTERPRISE_USER;
                } else {
                    joinConfPermissionType = JoinConfPermissionType.PERMIT_INVITED_USER;
                }
            }
        });

        handleVmrConf();
        handleShareVmr();

        needPasswordSwitch = rootView.findViewById(R.id.switch_need_password);
        guestPwdView = rootView.findViewById(R.id.guest_pwd_view);
        guestPwd = rootView.findViewById(R.id.guest_pwd);
        customMsg = rootView.findViewById(R.id.custom_message);
        maxNumber = rootView.findViewById(R.id.max_num_edit);
        autoPublishSummarySwitch = rootView.findViewById(R.id.switch_auto_publish_summary);

        needPasswordSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (guestPwdView == null) {
                    return;
                }
                if (isChecked) {
                    guestPwdView.setVisibility(View.VISIBLE);
                } else {
                    guestPwdView.setVisibility(View.GONE);
                }
            }
        });

        handleAutoMute();

        return rootView;
    }

    private void handleAutoMute() {
        RadioGroup autoMutePersonGroup = rootView.findViewById(R.id.auto_mute_person_group);
        ((RadioButton)rootView.findViewById(R.id.auto_mute_person_default)).setChecked(true);
        autoMutePersonGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.auto_mute_person_mute) {
                    autoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_MUTE;
                } else if (id == R.id.auto_mute_person_unmute) {
                    autoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_UNMUTE;
                } else {
                    autoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_DEFAULT;
                }
            }
        });

        RadioGroup autoMuteRoomGroup = rootView.findViewById(R.id.auto_mute_room_group);
        ((RadioButton)rootView.findViewById(R.id.auto_mute_room_default)).setChecked(true);
        autoMuteRoomGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.auto_mute_room_mute) {
                    hardTerminalAutoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_MUTE;
                } else if (id == R.id.auto_mute_room_unmute) {
                    hardTerminalAutoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_UNMUTE;
                } else {
                    hardTerminalAutoMuteMode = AutoMuteType.AUTO_MUTE_TYPE_DEFAULT;
                }
            }
        });
    }

    private void getDeviceResource() {
        HWMBizSdk.getBizOpenApi().getDeviceResource(new HwmCallback<DeviceResource>() {
            @Override
            public void onFailed(int retCode, String desc) {
                HCLog.e(TAG, " getDeviceResource error : " + retCode + " , desc : " + desc);
                roomsVmrId = null;
            }

            @Override
            public void onSuccess(DeviceResource deviceResource) {
                if (deviceResource == null) {
                    HCLog.e(TAG, " getDeviceResource error : deviceResource is null ");
                    roomsVmrId = null;
                    return;
                }
                int status = deviceResource.getVmrResource().getStatus();
                if (status == 0) {
                    roomsVmrId = deviceResource.getVmrResource().getVmrId();
                } else {
                    HCLog.e(TAG, " getDeviceResource invalid status : " + status);
                    roomsVmrId = null;
                }
            }
        });
    }

    private void getVmrInfoList() {
        HWMBizSdk.getBizOpenApi().getVmrInfoList(new HwmCallback<VmrInfoListModel>() {
            @Override
            public void onSuccess(VmrInfoListModel vmrInfoListModel) {
                vmrlist = vmrInfoListModel.getVmrInfoList();
                if (vmrlist.isEmpty()) {
                    clearVmrId();
                }
                isEnableShareVmr = vmrInfoListModel.isEnableShareVmr();
                if (shareVmrSwitch != null) {
                    if (shareVmrSwitch.isChecked()) {
                        shareVmrSwitch.setChecked(isEnableShareVmr);
                    }
                    shareVmrSwitch.setEnabled(isEnableShareVmr);
                }
            }

            @Override
            public void onFailed(int retCode, String desc) {
                HCLog.i(TAG,"getVmrList onFailed" + retCode + " " + desc);
                clearVmrId();
            }
        });
    }

    private void handleVmrConf() {
        fixIdChosenArea = rootView.findViewById(R.id.vmr_choose_fix_id_area);
        fixIdChosenArea.setVisibility(View.GONE);

        personnalIDSwitch = rootView.findViewById(R.id.switch_is_use_personnal_id);
        personnalIDSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    if (!vmrlist.isEmpty()) {
                        setVmrIdSpinner(MeetingIdType.PERSONAL_MEETING_ID);
                    } else {
                        DemoUtil.showToast("当前用户无个人会议id或云会议室id");
                        clearVmrId();
                    }
                } else {
                    clearVmrId();
                }

                // 打开个人会议id按钮时，不允许操作云会议室按钮
                useVmrConfSwitch.setEnabled(!isChecked);
                if (isChecked) {
                    shareVmrSwitch.setEnabled(false);
                } else {
                    shareVmrSwitch.setEnabled(isEnableShareVmr);
                }
            }
        });
        ModeType modeType = ModeUtil.getModeType(DemoUtil.getApplication());
        personnalIDSwitch.setVisibility(modeType == ModeType.MOBILE ? View.VISIBLE : View.GONE);
        handleCloudMeetingRoom();
    }

    private void handleShareVmr() {
        shareVmrSwitch = rootView.findViewById(R.id.switch_is_use_share_vmr);
        shareVmrSwitch.setEnabled(isEnableShareVmr);
        shareVmrSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                personnalIDSwitch.setEnabled(!isChecked);
                useVmrConfSwitch.setEnabled(!isChecked);
                // 共享云会议室仅支持随机会议ID
                vmrConfIdType = VmrIdType.RANDOM_ID;
                fixIdChosenArea.setVisibility(View.GONE);
                clearVmrId();
            }
        });
    }

    private void handleCloudMeetingRoom() {
        vmrIdTypeGroup = rootView.findViewById(R.id.vmr_id_group);
        allowModeAnyone = rootView.findViewById(R.id.allow_mode_everyone);
        allowModeEnterprise = rootView.findViewById(R.id.allow_mode_enterprise);
        allowModeInvite = rootView.findViewById(R.id.allow_mode_invite);

        allowModeAnyone.setChecked(true);
        vmrIdTypeGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (ModeUtil.getModeType(DemoUtil.getApplication()) == ModeType.MOBILE) {
                    onMobileVmrIdTypeChanged(id);
                } else {
                    onRoomsVmrIdTypeChanged(id);
                }
            }
        });

        useVmrConfSwitch = rootView.findViewById(R.id.switch_is_use_vmr_conf);
        LinearLayout vmrIdTypeArea = rootView.findViewById(R.id.vmr_id_type_area);
        useVmrConfSwitch.setChecked(false);
        vmrIdTypeArea.setVisibility(View.GONE);
        useVmrConfSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                isUseVmrConf = isChecked;
                vmrIdTypeArea.setVisibility(isUseVmrConf ? View.VISIBLE : View.GONE);
                if (!isChecked) {
                    fixIdChosenArea.setVisibility(View.GONE);
                }
                personnalIDSwitch.setEnabled(!isChecked);
                if (isChecked) {
                    shareVmrSwitch.setEnabled(false);
                    vmrIdTypeGroup.check(R.id.vmr_id_type_fixed);
                } else {
                    shareVmrSwitch.setEnabled(isEnableShareVmr);
                }
            }
        });

        vmrIdChosenSpinner = rootView.findViewById(R.id.fix_vmr_id_spinner);
        vmrIdChosenSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                if (position < 0 || position >= vmrlist.size()) {
                    return;
                }
                mobileSelectedVmrId = findVmrIdByFromList(vmrConferenceIdList.get(position));
                updateVmrJoinTypeAndWaitingRoomStatus(findVmrInfoFormList(mobileSelectedVmrId));
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
    }

    private void onRoomsVmrIdTypeChanged(int id) {
        if (id == R.id.vmr_id_type_fixed) {
            vmrConfIdType = VmrIdType.FIXED_ID;
        } else {
            vmrConfIdType = VmrIdType.RANDOM_ID;
        }
    }

    private void onMobileVmrIdTypeChanged(int id) {
        if (id == R.id.vmr_id_type_fixed) {
            vmrConfIdType = VmrIdType.FIXED_ID;
            if (!vmrlist.isEmpty()) {
                fixIdChosenArea.setVisibility(View.VISIBLE);
                setVmrIdSpinner(MeetingIdType.CLOUD_MEETING_ROOM_ID);
            } else {
                DemoUtil.showToast("当前用户无个人会议id或云会议室id");
                clearVmrId();
            }
        } else {
            vmrConfIdType = VmrIdType.RANDOM_ID;
            fixIdChosenArea.setVisibility(View.GONE);
        }
    }

    private void setVmrIdSpinner(MeetingIdType type) {
        vmrConferenceIdList.clear();
        for (VmrInfoModel vmrInfoModel : vmrlist) {
            if (vmrInfoModel.getType() != type) {
                continue;
            }
            vmrConferenceIdList.add(vmrInfoModel.getVmrConferenceId());
        }
        ArrayAdapter<String> vmrIdAdapter =
            new ArrayAdapter<>(Utils.getApp().getApplicationContext(), R.layout.main_spinner_item, vmrConferenceIdList);
        vmrIdAdapter.setDropDownViewResource(R.layout.support_simple_spinner_dropdown_item);
        vmrIdChosenSpinner.setAdapter(vmrIdAdapter);
        fixIdChosenArea.setVisibility(vmrConferenceIdList.isEmpty() ? View.GONE : View.VISIBLE);
        if (!vmrConferenceIdList.isEmpty()) {
            mobileSelectedVmrId = findVmrIdByFromList(vmrConferenceIdList.get(0));
            updateVmrJoinTypeAndWaitingRoomStatus(findVmrInfoFormList(mobileSelectedVmrId));
        }
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public void onDestroy() {
        personnalIDSwitch.setOnCheckedChangeListener(null);
        attendChooseSwitch.setOnCheckedChangeListener(null);
        shareVmrSwitch.setOnCheckedChangeListener(null);
        super.onDestroy();
    }

    private void clearVmrId() {
        fixIdChosenArea.setVisibility(View.GONE);
        mobileSelectedVmrId = null;
    }

    @SuppressLint("CheckResult")
    private void createConf(Activity activity) {
        if (!LoginStatusCache.isLogin()) {
            HCLog.e(TAG, "not login, create conf failed");
            DemoUtil.showToastDialog("createConf", SDKERR.SDK_LOGIN_E_ERR_NOT_LOGINED.getValue(),
                    "Not logged in, not available:此业务未登录不可用");
            return;
        }
        TextView subjectView = rootView.findViewById(R.id.subject);
        String subject = subjectView.getText().toString();
        if (TextUtils.isEmpty(subject)) {
            subject =  subjectView.getHint().toString();
        }
        RadioButton audioBtn = rootView.findViewById(R.id.radio_audio);
        ConfType confType = audioBtn.isChecked() ? ConfType.CONF_AUDIO : ConfType.CONF_VIDEO_AND_DATA;
        boolean needPassword = needPasswordSwitch.isChecked();
        Switch needWithMemberSwitch = rootView.findViewById(R.id.switch_with_attend);
        boolean needWithMember = needWithMemberSwitch.isChecked();
        Switch enableRecordSwitch = rootView.findViewById(R.id.switch_enable_record);
        boolean enableRecord = enableRecordSwitch.isChecked();
        Switch isAutoRecordSwitch = rootView.findViewById(R.id.switch_is_auto_record);
        boolean isAutoRecord = isAutoRecordSwitch.isChecked();
        Switch summarySwitch = rootView.findViewById(R.id.switch_summary);
        boolean needSummary = summarySwitch.isChecked();
        boolean autoPublishSummary = autoPublishSummarySwitch.isChecked();
        Switch enableMicSwitch = rootView.findViewById(R.id.switch_enable_mic);
        boolean enableMic = enableMicSwitch.isChecked();
        Switch enableCameraSwitch = rootView.findViewById(R.id.switch_enable_camera);
        boolean enableCamera = enableCameraSwitch.isChecked();
        Switch enableEarpieceSwitch = rootView.findViewById(R.id.switch_enable_earpiece);
        boolean enableEarpiece = enableEarpieceSwitch.isChecked();
        boolean isOpenWaitingRoom = enableWaitingRoomSwitch.isChecked();
        boolean isOpenWatermark = openWatermarkSwitch.isChecked();

        showLoading();
        CreateConfParam createConfParam = new CreateConfParam()
            .setSubject(subject)
            .setConfType(confType)
            .setVmrId(getVmrId())
            .setVmrConfIdType(vmrConfIdType)
            .setNeedPassword(needPassword)
            .setJoinConfRestrictionType(joinConfPermissionType)
            .setMicOn(enableMic)
            .setCameraOn(enableCamera)
            .setRecordOn(enableRecord)
            .setAutoRecord(isAutoRecord)
            .setAutoPublishSummary(autoPublishSummary)
            .setDefaultSummaryState(needSummary ? SummaryState.SUMMARY_STATE_OPEN : SummaryState.SUMMARY_STATE_CLOSE)
            .setOpenWaitingRoom(isOpenWaitingRoom)
            .setOpenWatermark(isOpenWatermark)
            .setGuestPwd(guestPwd == null ? "" : guestPwd.getText().toString())
            .setCustomInfo(customMsg.getText().toString())
            .setSpeakerOff(enableEarpiece)
            .setAutoMuteMode(autoMuteMode)
            .setHardTerminalAutoMuteMode(hardTerminalAutoMuteMode);
        if (needWithMember) {
            createConfParam.setAttendeeMembers(attendeeList);
        }
        if (shareVmrSwitch.isChecked()) {
            createConfParam.setConfResType(ConfResType.CONF_RESTYPE_SHARE_VMR);
        }
        if (!TextUtils.isEmpty(maxNumber.getText().toString())) {
            int maxConcurrent;
            try {
                maxConcurrent = Integer.parseInt(maxNumber.getText().toString());
            } catch (NumberFormatException e) {
                DemoUtil.showToast("会议最大方数格式不正确");
                dismissLoading();
                return;
            }
            createConfParam.setConcurrentParticipants(maxConcurrent);
        }

        if (activity == null) {
            HWMSdk.getOpenApi(DemoUtil.getApplication()).createConf(createConfParam, this.completeHandler);
        } else {
            HWMSdk.getOpenApi(DemoUtil.getApplication()).createConf(activity, createConfParam, this.completeHandler);
        }
    }

    private String getVmrId() {
        String vmrId = null;
        if (ModeUtil.getModeType(DemoUtil.getApplication()) == ModeType.MOBILE) {
            if (!TextUtils.isEmpty(mobileSelectedVmrId)) {
                vmrId = mobileSelectedVmrId;
            }
        } else {
            if (!TextUtils.isEmpty(roomsVmrId)) {
                vmrId = roomsVmrId;
            }
        }
        return vmrId == null ? "" : vmrId;
    }

    private HwmCancelableCallBack<ConfInfo> completeHandler = new HwmCancelableCallBack<ConfInfo>() {
        @Override
        public void onSuccess(ConfInfo result) {
            doDismissDialogAndFragment();
            DemoUtil.showToast("创建会议成功");
        }

        @Override
        public void onFailed(int retCode, String desc) {
            HCLog.i(TAG,"create conf onFailed" + retCode + " " + desc);
            doDismissDialogAndFragment();
            String err = ErrorMessageFactory.create(retCode);
            if (!TextUtils.isEmpty(err)) {
                desc = err;
            }
            DemoUtil.showToastDialog("createConf", retCode, desc);
        }

        @Override
        public void onCancel() {
            dismissLoading();
        }
    };

    private String findVmrIdByFromList(String vmrConferenceId) {
        String vmrId = mVmrInfoModel.getVmrId();
        for (VmrInfoModel vmrInfoModel : vmrlist) {
            if (vmrInfoModel.getVmrConferenceId().equals(vmrConferenceId)) {
                vmrId = vmrInfoModel.getVmrId();
            }
        }
        return vmrId;
    }

    private VmrInfoModel findVmrInfoFormList(String vmrId) {
        VmrInfoModel vmrInfo = mVmrInfoModel;
        for (VmrInfoModel vmrInfoModel : vmrlist) {
            if (vmrInfoModel.getVmrId().equals(vmrId)) {
                vmrInfo = vmrInfoModel;
            }
        }
        return vmrInfo;
    }

    private void showChooseAttend(boolean isChecked) {
        if (isChecked) {
            ConfUI.getInstance().getAddAttendees().doAddAttendees(getActivity(), new ArrayList<>(),
                    " ", false, new HwmCallback<List<AttendeeModel>>() {
                        @Override
                        public void onFailed(int retCode, String desc) {
                            if (SDKERR.SDKERR_SUCCESS.getValue() != retCode) {
                                DemoUtil.showToast("添加与会者失败：" + desc);
                            }
                        }

                        @Override
                        public void onSuccess(List<AttendeeModel> attendeeModels) {
                            attendeeList = attendeeModels;
                        }
                    });
        }
    }

    private void updateVmrJoinTypeAndWaitingRoomStatus(VmrInfoModel model) {
        if (enableWaitingRoomSwitch != null) {
            enableWaitingRoomSwitch.setChecked(model.isOpenWaitingRoom());
        }
        int allowMode = model.getConfAllowJoinUserType().getValue();
        if (allowMode == ConfAllowJoinUserType.CONF_ALLOW_JOIN_ANYONE.getValue()) {
            if (allowModeAnyone != null) {
                allowModeAnyone.setChecked(true);
            }
        } else if (allowMode == ConfAllowJoinUserType.CONF_ALLOW_JOIN_IN_COMPANY_USER.getValue()) {
            if (allowModeEnterprise != null) {
                allowModeEnterprise.setChecked(true);
            }
        } else if (allowMode == ConfAllowJoinUserType.CONF_ALLOW_JOIN_INVITED_USER.getValue()) {
            if (allowModeInvite != null) {
                allowModeInvite.setChecked(true);
            }
        }
    }
}
