package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Switch;

import androidx.annotation.NonNull;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.sdk.model.conf.entity.HWMAcceptConfParam;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmsdk.common.SdkCallback;
import com.huawei.hwmsdk.enums.SDKERR;

public class CustomInComingAnswerFragment extends BaseDialogFragment {

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.in_coming_custom_answer, container, false);
        Switch isAudioAcceptSwitch = rootView.findViewById(R.id.is_audio_accept);
        Switch isSpeakerOffSwitch = rootView.findViewById(R.id.is_speaker_off_accept);
        Button acceptConf = rootView.findViewById(R.id.custom_answer_accept_conf);
        Button rejectConf = rootView.findViewById(R.id.custom_answer_reject_conf);

        acceptConf.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                HWMAcceptConfParam acceptConfParam = new HWMAcceptConfParam();
                acceptConfParam.setAudioAccept(isAudioAcceptSwitch.isChecked());
                acceptConfParam.setSpeakerOff(isSpeakerOffSwitch.isChecked());
                HWMBizSdk.getBizOpenApi().acceptConf(acceptConfParam, new SdkCallback<Void>() {
                    @Override
                    public void onFailed(SDKERR error) {
                        DemoUtil.showToast("接听来电失败 : " + error.getDescription());
                    }

                    @Override
                    public void onSuccess(Void unused) {
                        DemoUtil.showToast("接听成功");
                    }
                });
            }
        });

        rejectConf.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                HWMBizSdk.getBizOpenApi().rejectConf(new SdkCallback<Void>() {
                    @Override
                    public void onFailed(SDKERR error) {
                        DemoUtil.showToast("拒接来电失败 : " + error.getDescription());
                    }

                    @Override
                    public void onSuccess(Void unused) {
                        DemoUtil.showToast("拒接成功");
                    }
                });
            }
        });

        return rootView;
    }
}
