package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.RadioButton;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.sdk.model.conf.entity.HwmSettingVrbkDefaultImageMode;
import com.huawei.hwmconf.sdk.model.conf.entity.HwmVirtualBackgroundImageInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.HwmVirtualBackgroundInfo;
import com.huawei.hwmconf.sdk.util.Utils;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.utils.FileUtil;
import com.huawei.hwmlogger.HCLog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CustomVrBgDefaultImageFragment extends BaseDialogFragment {

    private static final String TAG = "CustomVrBgDefaultImageFragment";

    private static final String CUSTOM_VIRTUAL_BACKGROUND  = "customVirtualBackground";

    private RadioButton replaceButton;
    private RadioButton appendButton;
    private Button confirmButton;


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        View rootView = inflater.inflate(R.layout.fragment_custom_vrbg_default_image, container);
        replaceButton = rootView.findViewById(R.id.radio_replace);
        appendButton = rootView.findViewById(R.id.radio_append);
        confirmButton = rootView.findViewById(R.id.confirm_btn);
        confirmButton.setOnClickListener(view -> {
            dismiss();
            new Thread(this::setVirtualBackgroundDefaultImage).start();
        });

        return rootView;
    }

    private void setVirtualBackgroundDefaultImage() {

        if (getContext() == null) {
            return;
        }
        if (!FileUtil.checkAssetFolderExist(DemoUtil.getApplication(), CUSTOM_VIRTUAL_BACKGROUND)) {
            DemoUtil.showToast("设置失败");
            HCLog.e(TAG, "setVirtualBackgroundDefaultImage failed");
            return;
        }
        FileUtil.copyAssetFolder(DemoUtil.getApplication(), CUSTOM_VIRTUAL_BACKGROUND);
        String path = FileUtil.getFileDirPath(Utils.getApp()) + File.separator + CUSTOM_VIRTUAL_BACKGROUND;
        List<HwmVirtualBackgroundImageInfo> infoList = new ArrayList<>();
        File customVirtualBackground = FileUtil.getFileByPath(path);

        if (customVirtualBackground != null && FileUtil.isFileExist(path)) {
            File[] virtualBackgroundList = customVirtualBackground.listFiles();
            if (virtualBackgroundList == null) {
                return;
            }
            for (File file : virtualBackgroundList) {
                if (file == null || !file.exists()) {
                    continue;
                }
                infoList.add(new HwmVirtualBackgroundImageInfo().setImagePath(file.getPath()));
            }
            HwmVirtualBackgroundInfo hwmVirtualBackgroundInfo = new HwmVirtualBackgroundInfo();
            hwmVirtualBackgroundInfo.setMode(replaceButton.isChecked() ? HwmSettingVrbkDefaultImageMode.HwmSettingVrbkDefaultImageModeReplaceAll
                    : HwmSettingVrbkDefaultImageMode.HwmSettingVrbkDefaultImageModeAppend);
            hwmVirtualBackgroundInfo.setImageList(infoList);
            HWMBizSdk.getBizOpenApi().setVirtualBackgroundDefaultImages(hwmVirtualBackgroundInfo);
        }


    }




}
