
package com.huawei.hwmdemo.view.sdk;

import static com.huawei.hwmconf.presentation.constant.Constants.SECONDS_TO_MILLIS;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.Switch;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.presentation.error.ErrorMessageFactory;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfDetailModel;
import com.huawei.hwmconf.sdk.util.BaseDateUtil;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmlogger.HCLog;
import com.huawei.hwmsdk.common.SdkCallback;
import com.huawei.hwmsdk.enums.ConfAllowJoinUserType;
import com.huawei.hwmsdk.enums.ConfMediaType;
import com.huawei.hwmsdk.enums.SDKERR;
import com.huawei.hwmsdk.model.param.ModifySubCycleConfParam;
import com.huawei.hwmsdk.model.param.SubCycleConfParam;

import java.util.Date;

/**
 * 编辑周期子会议页面
 *
 * @author wuyusheng
 * @since 2021-10-15
 */
public class EditSubConfFragment extends BaseDialogFragment {
    private static final String TAG = EditSubConfFragment.class.getSimpleName();

    private View rootView;

    private TextView mSubject;

    private EditText mStartTime;

    private EditText mDuration;

    private RadioButton mAudioBtn;

    private RadioButton mVideoBtn;

    private RadioButton mAllowEveryoneBtn;

    private RadioButton mEnterpriseBtn;

    private RadioButton mInviteBtn;

    private Switch mIsAutoStartRecordSwitch;

    private Button mEditBtn;

    private ConfDetailModel mConfDetailModel;

    private SubCycleConfParam mSubCycleConfParam;

    private Listener mListener;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.edit_subconf_dialog_view, container, false);

        mSubject = rootView.findViewById(R.id.edit_sub_conf_subject);
        mStartTime = rootView.findViewById(R.id.edit_start_time);
        mDuration = rootView.findViewById(R.id.edit_duration);
        mAudioBtn = rootView.findViewById(R.id.radio_audio);
        mEditBtn = rootView.findViewById(R.id.edit_sub_conf_btn);
        mVideoBtn = rootView.findViewById(R.id.radio_video);
        mAllowEveryoneBtn = rootView.findViewById(R.id.allow_mode_everyone);
        mEnterpriseBtn = rootView.findViewById(R.id.allow_mode_enterprise);
        mInviteBtn = rootView.findViewById(R.id.allow_mode_invite);
        mIsAutoStartRecordSwitch = rootView.findViewById(R.id.switch_record_is_auto_start);
        boolean isAutoStartRecord = mIsAutoStartRecordSwitch.isChecked();

        mEditBtn.setOnClickListener(v -> {
            ModifySubCycleConfParam modifySubCycleConfParam = new ModifySubCycleConfParam();
            modifySubCycleConfParam.setConfId(mConfDetailModel.getConfId());
            modifySubCycleConfParam.setSubConfID(mSubCycleConfParam.getSubConfID());
            modifySubCycleConfParam.setConfMediaType(
                mAudioBtn.isChecked() ? ConfMediaType.CONF_MEDIA_AUDIO : ConfMediaType.CONF_MEDIA_VIDEO);

            Date modifiedTime =
                BaseDateUtil.convertStringToDate(mStartTime.getText().toString(), BaseDateUtil.FMT_YMDHMS);
            if (modifiedTime == null) {
                modifiedTime = new Date();
            }
            modifySubCycleConfParam.setStartTimeStamp(modifiedTime.getTime() / SECONDS_TO_MILLIS);
            modifySubCycleConfParam.setConfLen(Integer.parseInt(mDuration.getText().toString()));
            modifySubCycleConfParam.setIsAutoRecord(mIsAutoStartRecordSwitch.isChecked());
            modifySubCycleConfParam.setRecordAuthType(mSubCycleConfParam.getRecordAuthType());
            ConfAllowJoinUserType type = ConfAllowJoinUserType.CONF_ALLOW_JOIN_ANYONE;
            if (mEnterpriseBtn.isChecked()) {
                type = ConfAllowJoinUserType.CONF_ALLOW_JOIN_IN_COMPANY_USER;
            } else if (mInviteBtn.isChecked()) {
                type = ConfAllowJoinUserType.CONF_ALLOW_JOIN_INVITED_USER;
            }
            modifySubCycleConfParam.setCallInRestriction(type);
            modifySubCycleConfParam.setAllowGuestStartConf(isAutoStartRecord);

            showLoading();
            HWMBizSdk.getBizOpenApi().editSubCycleConf(modifySubCycleConfParam, new SdkCallback<Void>() {
                @Override
                public void onSuccess(Void v) {
                    DemoUtil.showToast("Edit sub cycle conf success");
                    doDismissDialogAndFragment();
                    mListener.onEditSubCycleConfSuccess();
                }

                @Override
                public void onFailed(SDKERR retCode) {
                    HCLog.i(TAG,"modifySubCycleConf onFailed" + retCode);
                    String err = ErrorMessageFactory.create(retCode);
                    if (TextUtils.isEmpty(err)) {
                        err = DemoUtil.getResContext().getString(R.string.hwmconf_edit_failed);
                    }
                    DemoUtil.showToastDialog("编辑周期子会议", retCode.getValue(), err);
                    doDismissDialogAndFragment();
                }
            });
        });
        return rootView;
    }

    @Override
    public void onDestroy() {
        HCLog.i("TAG", "onDestroy");
        super.onDestroy();
    }

    public void init(SubCycleConfParam subCycleConfParam, ConfDetailModel confDetailModel) {
        mSubCycleConfParam = subCycleConfParam;
        mConfDetailModel = confDetailModel;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        mSubject.setText(mConfDetailModel.getConfSubject());
        String startTime = BaseDateUtil.timeStamp2GMTDate(mSubCycleConfParam.getStartTimeStamp(), BaseDateUtil.FMT_YMDHMS);
        mStartTime.setText(startTime);
        mAudioBtn.setChecked(mSubCycleConfParam.getConfMediaType() == ConfMediaType.CONF_MEDIA_AUDIO);
        mVideoBtn.setChecked(mSubCycleConfParam.getConfMediaType() == ConfMediaType.CONF_MEDIA_VIDEO);
        mDuration.setText(String.valueOf((mSubCycleConfParam.getEndTimeStamp() - mSubCycleConfParam.getStartTimeStamp()) / 60));
        mAllowEveryoneBtn
            .setChecked(mSubCycleConfParam.getCallInRestriction() == ConfAllowJoinUserType.CONF_ALLOW_JOIN_ANYONE);
        mEnterpriseBtn.setChecked(
            mSubCycleConfParam.getCallInRestriction() == ConfAllowJoinUserType.CONF_ALLOW_JOIN_IN_COMPANY_USER);
        mInviteBtn.setChecked(
            mSubCycleConfParam.getCallInRestriction() == ConfAllowJoinUserType.CONF_ALLOW_JOIN_INVITED_USER);
        mIsAutoStartRecordSwitch.setChecked(mSubCycleConfParam.getIsAutoRecord());
    }

    public void setListener(Listener listener) {
        mListener = listener;
    }

    public interface Listener {
        void onEditSubCycleConfSuccess();
    }
}
