package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;

import androidx.annotation.NonNull;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmsdk.enums.SDKERR;
import com.huawei.hwmsdk.model.result.GuaranteedIpAddress;

import java.util.ArrayList;
import java.util.List;

public class GlobalGuaranteedIPFragment extends BaseDialogFragment {

    private View rootView;

    private EditText domain1;
    private EditText domain2;
    private EditText domain3;

    private EditText ip1;
    private EditText ip2;
    private EditText ip3;

    private Button button;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.sdk_global_guaranteed_ip, container, false);
        domain1 = rootView.findViewById(R.id.domain_1);
        domain2 = rootView.findViewById(R.id.domain_2);
        domain3 = rootView.findViewById(R.id.domain_3);

        ip1 = rootView.findViewById(R.id.guaranteed_ip_1);
        ip2 = rootView.findViewById(R.id.guaranteed_ip_2);
        ip3 = rootView.findViewById(R.id.guaranteed_ip_3);

        button = rootView.findViewById(R.id.set_guaranteed_ip_button);
        button.setOnClickListener(this::setGuaranteedIP);
        return rootView;
    }

    private void setGuaranteedIP(View view) {
        List<GuaranteedIpAddress> ipAddressList = new ArrayList<>();
        GuaranteedIpAddress address1 = new GuaranteedIpAddress();
        GuaranteedIpAddress address2 = new GuaranteedIpAddress();
        GuaranteedIpAddress address3 = new GuaranteedIpAddress();

        address1.setDomain(domain1.getText().toString());
        address1.setGuaranteedIps(ip1.getText().toString());
        address2.setDomain(domain2.getText().toString());
        address2.setGuaranteedIps(ip2.getText().toString());
        address3.setDomain(domain3.getText().toString());
        address3.setGuaranteedIps(ip3.getText().toString());

        ipAddressList.add(address1);
        ipAddressList.add(address2);
        ipAddressList.add(address3);

        SDKERR sdkerr = HWMBizSdk.getBizOpenApi().setGlobalGuaranteedIpAddresses(ipAddressList);
        DemoUtil.showToastDialog("设置管理面保底IP", sdkerr.getValue(), sdkerr.getDescription());
        doDismissDialogAndFragment();
    }
}
