package com.huawei.hwmdemo.view.sdk;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmsdk.enums.SDKERR;

/**
 * 设置会控保底地址界面
 *
 */
public class GuaranteedAddressesSettingFragment extends BaseDialogFragment {
    View rootView;

    TextView guaranteedAddressesView;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.sdk_guaranteed_addresses_setting, container, false);
        guaranteedAddressesView = rootView.findViewById(R.id.ip);
        Button setGuaranteedAddressesBtn = rootView.findViewById(R.id.set_guaranteed_addresses_btn);
        setGuaranteedAddressesBtn.setOnClickListener(this::setGuaranteedAddresses);
        return rootView;
    }

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
    }

    private void setGuaranteedAddresses(View v) {
        String ip = "";
        if (guaranteedAddressesView != null) {
            CharSequence text = guaranteedAddressesView.getText();
            if (text != null) {
                ip = text.toString();
            }
        }
        SDKERR sdkerr = HWMBizSdk.getBizOpenApi().setGuaranteedIpAddresses(ip);
        DemoUtil.showToastDialog("设置保底IP", sdkerr.getValue(), sdkerr.getDescription());
        doDismissDialogAndFragment();
    }

}
