package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;

import androidx.annotation.NonNull;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.constant.ConfigConstant;
import com.huawei.hwmdemo.utils.PreferencesUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;

public class LogKeepDaysFragment extends BaseDialogFragment {
    public final static String TAG = LogKeepDaysFragment.class.getSimpleName();

    private View rootView;

    private EditText logKeepDays;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.log_keep_days_layout, container, false);

        logKeepDays = rootView.findViewById(R.id.log_keep_days_input);
        logKeepDays.setText(
            PreferencesUtil.getStringPreference(getActivity().getApplicationContext(), ConfigConstant.KEY_LOG_KEEP_DAYS, "0"));

        Button saveBtn = rootView.findViewById(R.id.save_btn);
        saveBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String value = logKeepDays.getText().toString();
                PreferencesUtil.setStringPreferences(getActivity().getApplicationContext(),
                    ConfigConstant.KEY_LOG_KEEP_DAYS, value);
                HWMSdk.getSdkConfig().setLogKeepDays(Integer.parseInt(value));
                dismiss();
            }
        });
        return rootView;
    }

}
