package com.huawei.hwmdemo.view.sdk;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.hwmconf.sdk.model.conf.entity.ConfInfo;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.dependency.MeetingInfoChangeListener;
import com.huawei.hwmdemo.dependency.SdkHelper;
import com.huawei.hwmdemo.view.ToastLogsActivity;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;

public class MeetingInfoFragment extends BaseDialogFragment implements MeetingInfoChangeListener {
    public final static String TAG = MeetingInfoFragment.class.getSimpleName();
    private View rootView;
    private TextView customMsgTv;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        SdkHelper.getInstance().setMeetingInfoChangeListener(this);
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.sdk_meeting_info, container, false);
        customMsgTv = rootView.findViewById(R.id.tv_custom_msg);
        rootView.findViewById(R.id.btn_toast_log).setOnClickListener(v -> {
            startActivity(new Intent(getContext(), ToastLogsActivity.class));
        });
        ConfInfo confInfo = SdkHelper.getInstance().getConfInfoCache();
        if (confInfo != null) {
            customMsgTv.setText(confInfo.getCustomInfo());
        }
        return rootView;
    }

    @Override
    public void onConfDetailNotify(ConfInfo confInfo) {
        if (customMsgTv != null) {
            customMsgTv.setText(confInfo.getCustomInfo());
        }
    }
}
