package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.EditText;
import android.widget.RadioGroup;

import androidx.annotation.NonNull;

import com.huawei.hwmconf.presentation.model.HWMIncomingAnswerType;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.utils.PreferenceUtils;
import com.huawei.hwmsdk.enums.HardCodecMode;

public class MeetingSettingFragment extends BaseDialogFragment {
    public final static String TAG = MeetingSettingFragment.class.getSimpleName();

    private RadioGroup mRgHighRes;

    private RadioGroup mRgConfIncomingCamera;

    private RadioGroup mRgConfIncomingMic;

    private RadioGroup mRgConfIncomingStrategy;

    private RadioGroup mRgConfCustomAddAttendee;

    private RadioGroup mRgConfRemoteMode;

    private RadioGroup mRgConfForceHardCodec;

    private RadioGroup mRgConfHardCodecMode;

    private RadioGroup mRgConfDisableScreenShare;

    private RadioGroup mRgConfDisableScreenShareAudioCapture;

    private RadioGroup mRgConfShowControllerQr;

    private RadioGroup mRgConfDefaultVideoLayoutPip;

    private EditText mEtConfMaxGalleryVideoCount;

    private EditText mEtConfMaxPresenterVideoCount;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (getDialog() != null) {
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        }
        View vRoot = inflater.inflate(R.layout.sdk_meeting_setting, container, false);
        mRgHighRes = vRoot.findViewById(R.id.rg_high_res);
        mRgConfIncomingCamera = vRoot.findViewById(R.id.rg_conf_incoming_camera);
        mRgConfIncomingMic = vRoot.findViewById(R.id.rg_conf_incoming_mic);
        mRgConfIncomingStrategy = vRoot.findViewById(R.id.rg_conf_incoming_strategy);
        mRgConfCustomAddAttendee = vRoot.findViewById(R.id.rg_conf_custom_add_attendee);
        mRgConfRemoteMode = vRoot.findViewById(R.id.rg_conf_custom_remote_mode);
        mRgConfForceHardCodec = vRoot.findViewById(R.id.rg_conf_custom_force_hard_codec);
        mRgConfHardCodecMode = vRoot.findViewById(R.id.rg_conf_custom_hard_codec_mode);
        mRgConfDisableScreenShare = vRoot.findViewById(R.id.rg_conf_disable_screen_share);
        mRgConfDisableScreenShareAudioCapture = vRoot.findViewById(R.id.rg_conf_disable_screen_share_audio_capture);
        mRgConfShowControllerQr = vRoot.findViewById(R.id.rg_conf_show_controller_qr);
        mRgConfDefaultVideoLayoutPip = vRoot.findViewById(R.id.rg_conf_default_video_layout_pip);
        mEtConfMaxGalleryVideoCount = vRoot.findViewById(R.id.et_max_gallery_video_count);
        mEtConfMaxPresenterVideoCount = vRoot.findViewById(R.id.et_max_presenter_video_count);
        initPreviousView();
        vRoot.findViewById(R.id.btn_save).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String maxGalleryVideoCountStr = mEtConfMaxGalleryVideoCount.getText().toString().trim();
                if (TextUtils.isEmpty(maxGalleryVideoCountStr)) {
                    DemoUtil.showToast("请填写画廊模式最多画面数");
                    return;
                }
                int maxGalleryVideoCount = Integer.parseInt(maxGalleryVideoCountStr);
                if (maxGalleryVideoCount < 4 || maxGalleryVideoCount > 25) {
                    DemoUtil.showToast("画廊模式最多画面数范围是4~25");
                    return;
                }
                String maxPresenterVideoCountStr = mEtConfMaxPresenterVideoCount.getText().toString().trim();
                if (TextUtils.isEmpty(maxPresenterVideoCountStr)) {
                    DemoUtil.showToast("请填写演讲者模式最多小画面数");
                    return;
                }
                int maxPresenterVideoCount = Integer.parseInt(maxPresenterVideoCountStr);
                if (maxPresenterVideoCount < 1 || maxPresenterVideoCount > 9) {
                    DemoUtil.showToast("演讲者模式最多小画面数范围是1~9");
                    return;
                }

                int highResCheckedId = mRgHighRes.getCheckedRadioButtonId();
                DemoUtil.setCustom(NeedCustomType.HIGH_RESOLUTION_FIRST, highResCheckedId == R.id.rb_high_res_on);
                int confIncomingCameraCheckedId = mRgConfIncomingCamera.getCheckedRadioButtonId();
                DemoUtil.setCustom(NeedCustomType.CONF_OPEN_CAMERA, confIncomingCameraCheckedId == R.id.rb_conf_incoming_camera_on);
                int confIncomingMicCheckedId = mRgConfIncomingMic.getCheckedRadioButtonId();
                DemoUtil.setCustom(NeedCustomType.CONF_OPEN_MIC, confIncomingMicCheckedId == R.id.rb_conf_incoming_mic_on);
                int confIncomingStrategy = getConfIncomingStrategy();
                PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_INCOMING_CONF, confIncomingStrategy, DemoUtil.getApplication());
                DemoUtil.setCustom(NeedCustomType.SHOW_CUSTOM_INCOMING, confIncomingStrategy != HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType());
                int confCustomAddAttendeeCheckedId = mRgConfCustomAddAttendee.getCheckedRadioButtonId();
                DemoUtil.setCustom(NeedCustomType.ADD_ATTENDEES, confCustomAddAttendeeCheckedId == R.id.rb_conf_custom_add_attendee_on);
                int confRemoteModeCheckedId = mRgConfRemoteMode.getCheckedRadioButtonId();
                DemoUtil.setCustom(NeedCustomType.REMOTE_MODE, confRemoteModeCheckedId == R.id.rb_conf_custom_remote_mode_on);
                int confForceHardCodecCheckedId = mRgConfForceHardCodec.getCheckedRadioButtonId();
                DemoUtil.setCustom(NeedCustomType.FORCE_HARD_CODEC, confForceHardCodecCheckedId == R.id.rb_conf_custom_force_hard_codec_on);
                HardCodecMode hardCodecMode = getHardCodecMode();
                DemoUtil.setHardCodecMode(hardCodecMode);
                int confDisableScreenShareCheckedId = mRgConfDisableScreenShare.getCheckedRadioButtonId();
                DemoUtil.setCustom(NeedCustomType.DISABLE_SCREEN_SHARE, confDisableScreenShareCheckedId == R.id.rb_conf_disable_screen_share_on);
                int confDisableScreenShareAudioCaptureCheckedId = mRgConfDisableScreenShareAudioCapture.getCheckedRadioButtonId();
                DemoUtil.setCustom(NeedCustomType.DISABLE_SCREEN_SHARE_AUDIO_CAPTURE, confDisableScreenShareAudioCaptureCheckedId == R.id.rb_conf_disable_screen_share_audio_capture_on);
                int confShowControllerQr = mRgConfShowControllerQr.getCheckedRadioButtonId();
                DemoUtil.setCustom(NeedCustomType.VISION_SHOW_CONTROLLER_QR, confShowControllerQr == R.id.rb_conf_show_controller_qr_on);
                int confDefaultVideoLayoutPipId = mRgConfDefaultVideoLayoutPip.getCheckedRadioButtonId();
                DemoUtil.setCustom(NeedCustomType.VISION_DEFAULT_VIDEO_LAYOUT_PIP, confDefaultVideoLayoutPipId == R.id.rb_conf_default_video_layout_pip_on);

                PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.MAX_GALLERY_VIDEO_COUNT, maxGalleryVideoCount, DemoUtil.getApplication());
                PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.MAX_PRESENTER_VIDEO_COUNT, maxPresenterVideoCount, DemoUtil.getApplication());
                dismiss();
                showLoading();
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    dismissLoading();
                    DemoUtil.restartApplication();
                }, 1500L);
            }
        });
        return vRoot;
    }

    @NonNull
    private HardCodecMode getHardCodecMode() {
        int confHardCodecModeCheckedId = mRgConfHardCodecMode.getCheckedRadioButtonId();
        HardCodecMode hardCodecMode;
        if (confHardCodecModeCheckedId == R.id.rb_conf_custom_hard_codec_encoding) {
            hardCodecMode = HardCodecMode.HARD_CODEC_MODE_FORCED_ENCODING;
        } else if (confHardCodecModeCheckedId == R.id.rb_conf_custom_hard_codec_decoding) {
            hardCodecMode = HardCodecMode.HARD_CODEC_MODE_FORCED_DECODING;
        } else {
            hardCodecMode = HardCodecMode.HARD_CODEC_MODE_DEFAULT;
        }
        return hardCodecMode;
    }

    private int getConfIncomingStrategy() {
        int confIncomingStrategyCheckedId = mRgConfIncomingStrategy.getCheckedRadioButtonId();
        int confIncomingStrategy = HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType();
        if (R.id.rb_conf_incoming_strategy_auto_answer == confIncomingStrategyCheckedId) {
            confIncomingStrategy = HWMIncomingAnswerType.HWM_INCOMING_AUTO_ANSWER.getType();
        } else if (R.id.rb_conf_incoming_strategy_auto_decline == confIncomingStrategyCheckedId) {
            confIncomingStrategy = HWMIncomingAnswerType.HWM_IMCOMING_AUTO_DECLINE.getType();
        }
        return confIncomingStrategy;
    }

    private void initPreviousView() {
        if (DemoUtil.needCustom(NeedCustomType.CONF_OPEN_CAMERA)) {
            mRgConfIncomingCamera.check(R.id.rb_conf_incoming_camera_on);
        } else {
            mRgConfIncomingCamera.check(R.id.rb_conf_incoming_camera_off);
        }
        if (DemoUtil.needCustom(NeedCustomType.CONF_OPEN_MIC)) {
            mRgConfIncomingMic.check(R.id.rb_conf_incoming_mic_on);
        } else {
            mRgConfIncomingMic.check(R.id.rb_conf_incoming_mic_off);
        }
        int confIncomingStrategy = PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_INCOMING_CONF,
                HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType(), DemoUtil.getApplication());
        if (HWMIncomingAnswerType.HWM_INCOMING_AUTO_ANSWER.getType() == confIncomingStrategy) {
            mRgConfIncomingStrategy.check(R.id.rb_conf_incoming_strategy_auto_answer);
        } else if (HWMIncomingAnswerType.HWM_IMCOMING_AUTO_DECLINE.getType() == confIncomingStrategy) {
            mRgConfIncomingStrategy.check(R.id.rb_conf_incoming_strategy_auto_decline);
        } else {
            mRgConfIncomingStrategy.check(R.id.rb_conf_incoming_strategy_default);
        }
        if (DemoUtil.needCustom(NeedCustomType.ADD_ATTENDEES)) {
            mRgConfCustomAddAttendee.check(R.id.rb_conf_custom_add_attendee_on);
        } else {
            mRgConfCustomAddAttendee.check(R.id.rb_conf_custom_add_attendee_off);
        }
        if (DemoUtil.needCustom(NeedCustomType.REMOTE_MODE)) {
            mRgConfRemoteMode.check(R.id.rb_conf_custom_remote_mode_on);
        } else {
            mRgConfRemoteMode.check(R.id.rb_conf_custom_remote_mode_off);
        }
        initPreviousConfVideoSetting();
    }

    private void initPreviousConfVideoSetting() {
        if (DemoUtil.needCustom(NeedCustomType.HIGH_RESOLUTION_FIRST)) {
            mRgHighRes.check(R.id.rb_high_res_on);
        } else {
            mRgHighRes.check(R.id.rb_high_res_off);
        }
        if (DemoUtil.needCustom(NeedCustomType.FORCE_HARD_CODEC)) {
            mRgConfForceHardCodec.check(R.id.rb_conf_custom_force_hard_codec_on);
        } else {
            mRgConfForceHardCodec.check(R.id.rb_conf_custom_force_hard_codec_off);
        }
        if (DemoUtil.getHardCodecMode() == HardCodecMode.HARD_CODEC_MODE_DEFAULT) {
            mRgConfHardCodecMode.check(R.id.rb_conf_custom_hard_codec_default);
        } else if (DemoUtil.getHardCodecMode() == HardCodecMode.HARD_CODEC_MODE_FORCED_ENCODING) {
            mRgConfHardCodecMode.check(R.id.rb_conf_custom_hard_codec_encoding);
        } else if (DemoUtil.getHardCodecMode() == HardCodecMode.HARD_CODEC_MODE_FORCED_DECODING) {
            mRgConfHardCodecMode.check(R.id.rb_conf_custom_hard_codec_decoding);
        }
        initPreviousConfShareSetting();
        if (DemoUtil.needCustom(NeedCustomType.VISION_SHOW_CONTROLLER_QR)) {
            mRgConfShowControllerQr.check(R.id.rb_conf_show_controller_qr_on);
        } else {
            mRgConfShowControllerQr.check(R.id.rb_conf_show_controller_qr_off);
        }
        if (DemoUtil.needCustom(NeedCustomType.VISION_DEFAULT_VIDEO_LAYOUT_PIP)) {
            mRgConfDefaultVideoLayoutPip.check(R.id.rb_conf_default_video_layout_pip_on);
        } else {
            mRgConfDefaultVideoLayoutPip.check(R.id.rb_conf_default_video_layout_pip_off);
        }
        int maxGalleryVideoCount = PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.MAX_GALLERY_VIDEO_COUNT, 4, DemoUtil.getApplication());
        mEtConfMaxGalleryVideoCount.setText(String.valueOf(maxGalleryVideoCount));
        int maxPresenterVideoCount = PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.MAX_PRESENTER_VIDEO_COUNT, 4, DemoUtil.getApplication());
        mEtConfMaxPresenterVideoCount.setText(String.valueOf(maxPresenterVideoCount));
    }

    private void initPreviousConfShareSetting() {
        if (DemoUtil.needCustom(NeedCustomType.DISABLE_SCREEN_SHARE)) {
            mRgConfDisableScreenShare.check(R.id.rb_conf_disable_screen_share_on);
        } else {
            mRgConfDisableScreenShare.check(R.id.rb_conf_disable_screen_share_off);
        }
        if (DemoUtil.needCustom(NeedCustomType.DISABLE_SCREEN_SHARE_AUDIO_CAPTURE)) {
            mRgConfDisableScreenShareAudioCapture.check(R.id.rb_conf_disable_screen_share_audio_capture_on);
        } else {
            mRgConfDisableScreenShareAudioCapture.check(R.id.rb_conf_disable_screen_share_audio_capture_off);
        }
    }
}
