package com.huawei.hwmdemo.view.sdk;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.RadioButton;
import android.widget.RadioGroup;

import androidx.annotation.NonNull;

import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.MenuConfigActivity;

public class MeetingUiFragment extends BaseDialogFragment {
    public final static String TAG = MeetingUiFragment.class.getSimpleName();

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (getDialog() != null) {
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        }
        View vRoot = inflater.inflate(R.layout.sdk_meeting_ui, container, false);
        vRoot.findViewById(R.id.btn_custom_menu).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (getActivity() != null) {
                    getActivity().startActivity(new Intent(getActivity(), MenuConfigActivity.class));
                }
            }
        });
        RadioGroup rgCustomUi = vRoot.findViewById(R.id.rg_custom_ui);
        rgCustomUi.check(DemoUtil.needCustom(NeedCustomType.CONF_MENU) ? R.id.rb_custom_ui_on : R.id.rb_custom_ui_off);

        RadioGroup rgDisableAddressBook = vRoot.findViewById(R.id.rg_disable_address_book);
        rgDisableAddressBook.check(DemoUtil.needCustom(NeedCustomType.VISION_ADDRESS_BOOK_DISABLED) ? R.id.rb_disable_address_book_on : R.id.rb_disable_address_book_off);

        RadioGroup rgScreenShareJumpPage = vRoot.findViewById(R.id.rg_screen_share_jump_page);
        rgScreenShareJumpPage.check(DemoUtil.needCustom(NeedCustomType.VISION_SCREEN_SHARE_JUMP_TO_MAIN_ACTIVITY) ? R.id.rb_screen_share_jump_to_main_activity : R.id.rb_screen_share_jump_to_launcher);

        vRoot.findViewById(R.id.btn_save).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                RadioButton rbCustomUiOn = vRoot.findViewById(R.id.rb_custom_ui_on);
                DemoUtil.setCustom(NeedCustomType.CONF_MENU, rbCustomUiOn.isChecked());
                RadioButton rbDisableAddressBook = vRoot.findViewById(R.id.rb_disable_address_book_on);
                DemoUtil.setCustom(NeedCustomType.VISION_ADDRESS_BOOK_DISABLED, rbDisableAddressBook.isChecked());
                RadioButton rbScreenShareJumpToMainActivity = vRoot.findViewById(R.id.rb_screen_share_jump_to_main_activity);
                DemoUtil.setCustom(NeedCustomType.VISION_SCREEN_SHARE_JUMP_TO_MAIN_ACTIVITY, rbScreenShareJumpToMainActivity.isChecked());
                dismiss();
                showLoading();
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    dismissLoading();
                    DemoUtil.restartApplication();
                }, 1500L);
            }
        });
        return vRoot;
    }
}
