package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmcommonui.ui.popup.toast.ToastBuilder;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmsdk.common.SdkCallback;
import com.huawei.hwmsdk.enums.SDKERR;

public class SetCustomInfoFragment extends BaseDialogFragment {

    private View rootView;

    private EditText customInfoEditText;

    private Button setBtn;

    private SdkCallback<Void> callback = new SdkCallback<Void>() {
        @Override
        public void onFailed(SDKERR error) {
            ToastBuilder.showToast("setCustomInfo failed, error = " + error, Toast.LENGTH_SHORT, Gravity.CENTER);
        }

        @Override
        public void onSuccess(Void unused) {
            ToastBuilder.showToast("setCustomInfo onSuccess", Toast.LENGTH_SHORT, Gravity.CENTER);
        }
    };

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.set_custom_info_fragment, container);
        customInfoEditText = rootView.findViewById(R.id.custom_info_editText);
        setBtn = rootView.findViewById(R.id.set_btn);
        setBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String customInfo = customInfoEditText.getText().toString();
                HWMBizSdk.getBizOpenApi().setMeetingCustomInfo(customInfo, callback);
            }
        });

        return rootView;
    }
}
