package com.huawei.hwmdemo.view.sdk;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioButton;

import androidx.annotation.NonNull;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.sdk.model.conf.entity.HWMAvatarStyle;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.utils.BitmapUtil;
import com.huawei.hwmsdk.enums.SDKERR;

import java.io.File;

public class SetParticipantAvatarStyleFragment extends BaseDialogFragment {

    private View rootView;

    private EditText backgroundColorEditText;

    private EditText avatarTextColorEditText;

    private EditText boardAvatarPathEditText;

    private EditText pstnAvatarPathEditText;

    private RadioButton firstLetterRadioButton;

    private RadioButton familyNameRadioButton;

    private RadioButton avatarShapeCircle;

    private Button setButton;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        rootView = inflater.inflate(R.layout.sdk_set_participant_avatar_style, container, false);
        backgroundColorEditText = rootView.findViewById(R.id.avatar_background_color);
        avatarTextColorEditText = rootView.findViewById(R.id.avatar_text_color);
        boardAvatarPathEditText = rootView.findViewById(R.id.board_avatar_path);
        pstnAvatarPathEditText = rootView.findViewById(R.id.pstn_avatar_path);
        firstLetterRadioButton = rootView.findViewById(R.id.text_style_first_letter);
        familyNameRadioButton = rootView.findViewById(R.id.text_style_family_name);
        avatarShapeCircle = rootView.findViewById(R.id.avatar_shape_circle);
        setButton = rootView.findViewById(R.id.set_avatar_style);

        firstLetterRadioButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (familyNameRadioButton.isChecked()) {
                    familyNameRadioButton.setChecked(false);
                }
            }
        });

        familyNameRadioButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (firstLetterRadioButton.isChecked()) {
                    firstLetterRadioButton.setChecked(false);
                }
            }
        });

        setButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onSetButtonClicked();
            }
        });

        return rootView;
    }

    public void onSetButtonClicked() {
        String backgroundColor = backgroundColorEditText.getText().toString();
        String avatarTextColor = avatarTextColorEditText.getText().toString();
        HWMAvatarStyle.NameShowType nameShowType = HWMAvatarStyle.NameShowType.FAMILY_NAME;
        if (firstLetterRadioButton.isChecked()) {
            nameShowType = HWMAvatarStyle.NameShowType.FIRST_LETTER;
        }

        HWMAvatarStyle.AvatarShape avatarShape = HWMAvatarStyle.AvatarShape.CIRCLE;
        HWMAvatarStyle avatarStyle;
        try {
            avatarStyle = new HWMAvatarStyle(Integer.parseInt(backgroundColor), Integer.parseInt(avatarTextColor), nameShowType, avatarShape);
        } catch (NumberFormatException e) {
            DemoUtil.showToast("颜色格式有误");
            return;
        }

        File file1 = new File(boardAvatarPathEditText.getText().toString());
        if (file1.exists()) {
            Bitmap bitmap = BitmapUtil.decodeBitmapFromFile(boardAvatarPathEditText.getText().toString(), 100, 100);
            if (bitmap == null) {
                DemoUtil.showToast("大屏头像路径有误");
                return;
            }
            avatarStyle.setBoardIcon(bitmap);
        }
        File file2 = new File(pstnAvatarPathEditText.getText().toString());
        if (file2.exists()) {
            Bitmap bitmap = BitmapUtil.decodeBitmapFromFile(pstnAvatarPathEditText.getText().toString(), 100, 100);
            if (bitmap == null) {
                DemoUtil.showToast("PSTN头像路径有误");
                return;
            }
            avatarStyle.setPhoneIcon(bitmap);
        }

        if (HWMBizSdk.getBizOpenApi().setParticipantAvatarStyle(avatarStyle) == SDKERR.SDKERR_SUCCESS) {
            DemoUtil.showToast("头像风格设置成功");
            doDismissDialogAndFragment();
        } else {
            DemoUtil.showToast("设置失败");
        }
    }
}
