package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.sdk.util.Utils;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmsdk.enums.SDKERR;
import com.huawei.hwmsdk.enums.TargetLanguageType;

import java.util.List;

public class SubtitleInfoNotifyFragment extends BaseDialogFragment implements View.OnClickListener {

    private TargetLanguageType chosenLanguageType = TargetLanguageType.SUBTITLE_LANGUAGE_DEFAULT;

    private static final HwmCallback<Boolean> subscribeSubtitleCallback = new HwmCallback<Boolean>() {
        @Override
        public void onFailed(int retCode, String desc) {
            DemoUtil.showToast("subscribe subtitle failed, retCode: " + retCode + ", desc:" + desc);
        }

        @Override
        public void onSuccess(Boolean aBoolean) {
            DemoUtil.showToast("subscribe subtitle success");
        }
    };

    private static final HwmCallback<Boolean> unSubscribeSubtitleCallback = new HwmCallback<Boolean>() {
        @Override
        public void onFailed(int retCode, String desc) {
            DemoUtil.showToast("unsubscribe subtitle failed, retCode: " + retCode + ", desc:" + desc);
        }

        @Override
        public void onSuccess(Boolean aBoolean) {
            DemoUtil.showToast("unsubscribe subtitle success");
        }
    };

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.subtitle_info_notify, container, false);
        Button subscribeSubtitleButton = rootView.findViewById(R.id.subscribe_subtitle);
        subscribeSubtitleButton.setOnClickListener(this);
        Button unSubscribeSubtitleButton = rootView.findViewById(R.id.unsubscribe_subtitle);
        unSubscribeSubtitleButton.setOnClickListener(this);
        Button subscribeSubtitleLanguageButton = rootView.findViewById(R.id.subscribe_subtitle_language);
        subscribeSubtitleLanguageButton.setOnClickListener(this);
        Button getSubtitleLanguageButton = rootView.findViewById(R.id.get_subtitle_language);
        getSubtitleLanguageButton.setOnClickListener(this);

        Spinner spinner = rootView.findViewById(R.id.target_language_select_spinner);
        List<TargetLanguageType> languages = HWMBizSdk.getBizOpenApi().getSubtitleSupportLanguage();
        spinner.setAdapter(new ArrayAdapter<>(Utils.getResContext(), android.R.layout.simple_spinner_item, languages));

        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                if (adapterView.getItemAtPosition(i) instanceof TargetLanguageType) {
                    chosenLanguageType = (TargetLanguageType) adapterView.getItemAtPosition(i);
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });

        return rootView;
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.subscribe_subtitle) {
            HWMSdk.getOpenApi(Utils.getApp()).subscribeSubtitle(true, subscribeSubtitleCallback);
        } else if (view.getId() == R.id.unsubscribe_subtitle) {
            HWMSdk.getOpenApi(Utils.getApp()).subscribeSubtitle(false, unSubscribeSubtitleCallback);
        } else if (view.getId() == R.id.subscribe_subtitle_language) {
            SDKERR sdkerr = HWMSdk.getOpenApi(Utils.getApp()).subscribeSubtitleLanguage(chosenLanguageType);
            DemoUtil.showToast("subscribe subtitle language, sdkerr = " + sdkerr);
        } else if (view.getId() == R.id.get_subtitle_language) {
            List<TargetLanguageType> languageTypeList = HWMBizSdk.getBizOpenApi().getSubtitleSupportLanguage();
            if (languageTypeList == null || languageTypeList.isEmpty()) {
                DemoUtil.showToast("language list is null");
                return;
            }
            DemoUtil.showToast(languageTypeList.toString());
        }
    }
}
