package com.huawei.hwmdemo.view.sdkconfig;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.google.gson.Gson;
import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;

public class AddPeopleByAppidAuthActivity extends Activity {

    @SuppressLint("CheckResult")
    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.customize_add_people_by_appid_auth);
        TextView thirdAccountIdTextView = findViewById(R.id.third_account_id);
        TextView sipNumberTextView = findViewById(R.id.sip_number);
        TextView userPhoneTextView = findViewById(R.id.user_phone);
        TextView userNameTextView = findViewById(R.id.user_name);
        TextView corpIdTextView = findViewById(R.id.corp_id);

        findViewById(R.id.add_people).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                String thirdAccountId = thirdAccountIdTextView.getText().toString();
                String sipNumber = sipNumberTextView.getText().toString();
                String phoneNumber = userPhoneTextView.getText().toString();
                //昵称选填，不填，则以企业通讯录的为准
                String name = userNameTextView.getText().toString();
                String corpId = corpIdTextView.getText().toString();
                AttendeeModel attendeeModel;
                //三种方式选一即可， 第三方通讯录的id，仅仅对appid登录方式有效
                if (!TextUtils.isEmpty(thirdAccountId)) {
                     attendeeModel = AttendeeModel.buildAttendeeByThirdUserId(thirdAccountId, name);
                    attendeeModel.setOrgId(corpId);
                } else if (!TextUtils.isEmpty(sipNumber)) {
                    //三种方式选一即可，sip号码是会议企业通讯录的账号标示
                     attendeeModel = AttendeeModel.buildAttendeeBySipNumber(sipNumber,name);
                    attendeeModel.setOrgId(corpId);
                } else if (!TextUtils.isEmpty(phoneNumber)) {
                    //三种方式选一即可， 手机号码需要外呼权限
                     attendeeModel = AttendeeModel.buildAttendeeByPhone(phoneNumber, name);
                    attendeeModel.setOrgId(corpId);
                } else {
                    DemoUtil.showToast("三种入会方式需要选择一种");
                    return;
                }

                Intent resultIntent = new Intent();
                resultIntent.putExtra("attendeeModel", new Gson().toJson(attendeeModel));
                setResult(RESULT_OK, resultIntent);
                finish();
            }
        });
    }
}
