package com.huawei.hwmdemo.view.sdkconfig;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.util.SparseArray;
import android.view.View;

import androidx.fragment.app.DialogFragment;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.model.ApiPageModel;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseListFragment;
import com.huawei.hwmdemo.view.sdk.CameraOrientSettingFragment;
import com.huawei.hwmdemo.view.sdk.CapabilitiesConfigFragment;
import com.huawei.hwmdemo.view.sdk.CustomInComingAnswerFragment;
import com.huawei.hwmdemo.view.sdk.DisplayModeConfigFragment;
import com.huawei.hwmdemo.view.sdk.InComingConfigFragment;
import com.huawei.hwmdemo.view.sdk.LogKeepDaysFragment;
import com.huawei.hwmdemo.view.sdk.OpenCMSInterfaceTestFragment;
import com.huawei.hwmdemo.view.sdk.SetInitTypeFragment;
import com.huawei.hwmdemo.view.sdk.SetCustomInfoFragment;
import com.huawei.hwmdemo.view.sdk.SetParticipantAvatarStyleFragment;
import com.huawei.hwmdemo.view.sdk.SubtitleInfoNotifyFragment;
import com.huawei.hwmdemo.view.sdk.WaterMarkControlOptionConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.MenuConfigActivity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import io.reactivex.rxjava3.annotations.NonNull;

/**
 * 自定义需求demo
 */
public class CustomizeListFragment extends BaseListFragment {
    public final static String TAG = CustomizeListFragment.class.getSimpleName();
    private List<String> titles = Arrays.asList("自定义加人",
            "自定义账号通知处理", "自定义分享菜单", "自定义会中通知栏",
            "自定义日志路径", "自定义日志保存天数", "自定义菜单", "自定义会中标题栏点击弹出菜单", "自定义会中离会点击弹出菜单", "自定义会中录制功能弹窗文案",
            "自定义会中图标", "会中入会人隐藏已经离会的人", "与会者列表中不区分外部人员", "来电接听麦克风打开", "来电接听摄像头打开",
            "会议开启高清优先", "自定义接入站点（亚太站点）", "启用第三方视频采集",
            "会议来电时隐藏语音接听", "会议来电时隐藏视频接听（仅MCU会议生效）", "自定义会中显示头像",
            "自定义离会菜单", "自定义来电处理", "自定义会中分享链接", "自定义共享水印",
            "自定义渲染模式", "端到端加密", "强制结束和当前VMR会议资源冲突的会议",
            "自定义功能启用或屏蔽", "自定义悬浮窗", "自定义异步初始化", "摄像头固定采集角度设置",
            "不允许用户自定义虚拟背景图片", "会中支持遥控器操作", "支持断开音频入会功能", "自定义会中音视频悬浮窗通知",
            "关闭SDK日志自动收集与上报会中打点", "跳转自定义界面设置虚拟背景", "拦截共享", "自定义呼叫其他号码注入", "设置默认头像风格", "自定义来电弹窗",
            "开放会控接口", "setCustomInfo接口", "设置初始化方式", "字幕通知订阅");
    List<ApiPageModel> models = new ArrayList<>();
    private List<Class> fragments = Arrays.asList(
            null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
            null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
            null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);

    private static SparseArray<String> customTypeArray = new SparseArray();

    static {
        int index = 0;
        customTypeArray.put(index++, NeedCustomType.ADD_ATTENDEES);
        customTypeArray.put(index++, NeedCustomType.ACCOUNT_EVENT_HANDLE);
        customTypeArray.put(index++, NeedCustomType.SHARE_MENU);
        customTypeArray.put(index++, NeedCustomType.CONF_NOTIFICATION_DIFFERENCE);
        customTypeArray.put(index++, NeedCustomType.LOGGER_PATH);
        customTypeArray.put(index++, NeedCustomType.LOG_KEEP_DAYS);
        customTypeArray.put(index++, NeedCustomType.CONF_MENU);
        customTypeArray.put(index++, NeedCustomType.CONF_TITLE_BAR_POPWINDOW);
        customTypeArray.put(index++, NeedCustomType.CONF_LEAVE_CONF_POPWINDOW);
        customTypeArray.put(index++, NeedCustomType.CONF_UI_CUSTOM_TEXT);
        customTypeArray.put(index++, NeedCustomType.CONF_UI_CUSTOM_IMAGE);
        customTypeArray.put(index++, NeedCustomType.HIDE_ATTENDEE_HAS_LEFT_CONF);
        customTypeArray.put(index++, NeedCustomType.HIDE_EXTERNAL_LABEL);
        customTypeArray.put(index++, NeedCustomType.CONF_OPEN_MIC);
        customTypeArray.put(index++, NeedCustomType.CONF_OPEN_CAMERA);
        customTypeArray.put(index++, NeedCustomType.HIGH_RESOLUTION_FIRST);
        customTypeArray.put(index++, NeedCustomType.SITE_TYPE_STRATEGY);
        customTypeArray.put(index++, NeedCustomType.ENABLE_EXTERNAL_CAPTURE);
        customTypeArray.put(index++, NeedCustomType.CONF_HIDDEN_ACCEPT_AUDIO);
        customTypeArray.put(index++, NeedCustomType.CONF_HIDDEN_ACCEPT_VIDEO);
        customTypeArray.put(index++, NeedCustomType.SHOW_CUSTOM_AVATAR);
        customTypeArray.put(index++, NeedCustomType.SHOW_CUSTOM_LEAVE);
        customTypeArray.put(index++, NeedCustomType.SHOW_CUSTOM_INCOMING);
        customTypeArray.put(index++, NeedCustomType.SHARE_LINK);
        customTypeArray.put(index++, NeedCustomType.WATER_MARK);
        customTypeArray.put(index++, NeedCustomType.DISPLAY_MODE);
        customTypeArray.put(index++, NeedCustomType.ENABLE_E2E_ENCRYPT);
        customTypeArray.put(index++, NeedCustomType.IS_STOP_CONFLICT_CONF);
        customTypeArray.put(index++, NeedCustomType.FEATURE_CONFIG);
        customTypeArray.put(index++, NeedCustomType.FLOATING_VIEW_STYLE_CONFIG);
        customTypeArray.put(index++, NeedCustomType.ASYNC_INIT_SDK_CONFIG);
        customTypeArray.put(index++, NeedCustomType.CAMERA_ORIENT_CONFIG);
        customTypeArray.put(index++, NeedCustomType.NOT_ALLOW_USER_CUSTOM_IMAGE);
        customTypeArray.put(index++, NeedCustomType.SUPPORT_REMOTE_CONTROL);
        customTypeArray.put(index++, NeedCustomType.SUPPORT_DISCONNECT_AUDIO);
        customTypeArray.put(index++, NeedCustomType.FLOATING_WINDOW_HANDLE);
        customTypeArray.put(index++, NeedCustomType.ALLOW_MEETING_UT);
        customTypeArray.put(index++, NeedCustomType.CUSTOM_VIRTUAL_BACKGROUND);
        customTypeArray.put(index++, NeedCustomType.CUSTOM_INTERRUPT_SHARE);
        customTypeArray.put(index++, NeedCustomType.CUSTOM_CALL_OTHER_NUMBERS);
    }

    @Override
    public void onStart() {
        super.onStart();
        mText.setVisibility(View.VISIBLE);
    }

    @Override
    public List<ApiPageModel> getItems() {
        models.clear();
        for (int i = 0; i < titles.size(); i++) {
            ApiPageModel item = new ApiPageModel();
            item.page = fragments.get(i);
            item.name = titles.get(i);
            item.isShowCheck = true;
            models.add(item);
        }
        for (int i = 0; i < titles.size(); i++) {
            models.get(i).checkStyle = getSPStateShowMenu(i);
        }
        return models;
    }

    @SuppressLint("CheckResult")
    @Override
    public void handleItemClick(int position, ApiPageModel data) {
        setSPStateShowMenu(position);
    }

    @Override
    public void handleItemLongClick(int position, ApiPageModel data) {
        if ("自定义菜单".equals(titles.get(position))) {
            getActivity().startActivity(new Intent(getActivity(), MenuConfigActivity.class));
        }
    }

    public boolean getSPStateShowMenu(int position) {
        if (customTypeArray.get(position) != null) {
            return DemoUtil.needCustom(customTypeArray.get(position));
        }
        return false;
    }

    public void setSPStateShowMenu(int position) {
        if (customTypeArray.get(position) != null) {
            DemoUtil.setCustom(customTypeArray.get(position), models.get(position));
        }
        if (position == getPosition(NeedCustomType.CONF_HIDDEN_ACCEPT_AUDIO)) {
            int videoPosition = getPosition(NeedCustomType.CONF_HIDDEN_ACCEPT_VIDEO);
            // 会议来电时隐藏语音接听，如果已开了只隐藏视频接入，则需要把隐藏视频接听选中状态去掉
            if (DemoUtil.needCustom(NeedCustomType.CONF_HIDDEN_ACCEPT_VIDEO)) {
                DemoUtil.setCustom(NeedCustomType.CONF_HIDDEN_ACCEPT_VIDEO, models.get(videoPosition));
                models.get(videoPosition).checkStyle = !models.get(videoPosition).checkStyle;
            }
        } else if (position == getPosition(NeedCustomType.CONF_HIDDEN_ACCEPT_VIDEO)) {
            int audioPosition = getPosition(NeedCustomType.CONF_HIDDEN_ACCEPT_AUDIO);
            // 会议来电时隐藏视频接听，如果已开了隐藏语音接听，则需要把隐藏语音接听选中状态去掉
            if (DemoUtil.needCustom(NeedCustomType.CONF_HIDDEN_ACCEPT_AUDIO)) {
                DemoUtil.setCustom(NeedCustomType.CONF_HIDDEN_ACCEPT_AUDIO, models.get(audioPosition));
                models.get(audioPosition).checkStyle = !models.get(audioPosition).checkStyle;
            }
        }
        models.get(position).checkStyle = !models.get(position).checkStyle;

        showFragment(position);

        mAdapter.notifyDataSetChanged();
    }

    private void showFragment(int position) {
        if ("自定义来电处理".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new InComingConfigFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        } else if ("自定义渲染模式".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new DisplayModeConfigFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        }  else if ("自定义功能启用或屏蔽".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new CapabilitiesConfigFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        } else if ("自定义日志保存天数".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new LogKeepDaysFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        } else if ("摄像头固定采集角度设置".equals(titles.get(position))) {
            if (models.get(position).checkStyle) {
                DialogFragment fragment = new CameraOrientSettingFragment();
                fragment.show(getActivity().getSupportFragmentManager(), null);
            } else {
                HWMBizSdk.getBizOpenApi().setCameraOrient(0, 0, false);
            }
        } else {
            showFragmentEx(position);
        }
    }

    private void showFragmentEx(int position) {
        if ("设置默认头像风格".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new SetParticipantAvatarStyleFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        } else if ("自定义来电弹窗".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new CustomInComingAnswerFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        } else if ("自定义共享水印".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new WaterMarkControlOptionConfigFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        } else if ("开放会控接口".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new OpenCMSInterfaceTestFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        } else if ("setCustomInfo接口".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new SetCustomInfoFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        } else if ("设置初始化方式".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new SetInitTypeFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        } else if ("字幕通知订阅".equals(titles.get(position)) && models.get(position).checkStyle) {
            DialogFragment fragment = new SubtitleInfoNotifyFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        }
    }

    private int getPosition(@NonNull String key) {
        for (int i = 0; i < customTypeArray.size(); i++) {
            if (key.equals(customTypeArray.valueAt(i))) {
                return customTypeArray.keyAt(i);
            }
        }
        return 0;
    }
}
