package com.huawei.hwmdemo.view.sdkconfig.menu;

import com.huawei.hwmdemo.delegate.DelegateHolder;
import com.huawei.hwmdemo.model.MenuGroup;

import java.util.List;

public class ParticipantMenuConfigFragment extends MenuConfigFragment {

    @Override
    protected void initData() {
        List<MenuGroup> participantMenuFeatures = DelegateHolder.getHwmUiDelegate().getParticipantMenuFeatures();
        for (MenuGroup participantMenuFeature : participantMenuFeatures) {
            addGroupData(participantMenuFeature.getName(), participantMenuFeature.getTag(), participantMenuFeature.getMenus());
        }
    }

    @Override
    public String getName() {
        return "与会者页面菜单";
    }

    @Override
    protected String getMenuHandleName() {
        return DelegateHolder.getHwmUiDelegate().getParticipantMenuHandle();
    }
}
