package com.huawei.hwmdemo.vision.dependency;

import com.huawei.hwmconf.sdk.dependency.CLMNotifyHandler;
import com.huawei.hwmconf.sdk.dependency.ConfEndedReason;
import com.huawei.hwmconf.sdk.model.call.entity.CallInfo;
import com.huawei.hwmconf.sdk.model.call.entity.HWMP2PConfRecordInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfStatus;
import com.huawei.hwmlogger.HCLog;
import com.huawei.hwmsdk.model.result.AudioQualityInfo;
import com.huawei.hwmsdk.model.result.MeetingInfo;
import com.huawei.hwmsdk.model.result.PoorNetWorkQualityInfo;

public class CustomVisionNotifyHandler implements CLMNotifyHandler {

    private static final String TAG = CustomVisionNotifyHandler.class.getSimpleName();

    @Override
    public void onCallEnded(CallInfo callInfo) {
        HCLog.i(TAG, "onCallEnded");
    }

    @Override
    public void onConfDetailNotify(ConfInfo confInfo) {
        HCLog.i(TAG, "onConfDetailNotify confInfo");
    }

    @Override
    public void onMeetingInfoChanged(MeetingInfo meetingInfo) {
        HCLog.i(TAG, "onConfDetailNotify meetingInfo");
    }

    @Override
    public void onPoorNetworkQualityInfoNotify(PoorNetWorkQualityInfo poorNetWorkInfo) {
        HCLog.i(TAG, "onPoorNetworkQualityInfoNotify");
    }

    @Override
    public void onAudioQualityNotify(AudioQualityInfo audioQualityInfo) {
        HCLog.i(TAG, "onAudioQualityNotify");
    }

    @Override
    public void onConfEnded(ConfEndedReason reason) {
        HCLog.i(TAG, "onConfEnded");
    }

    @Override
    public void onConfEnded(int retCode, String desc) {
        HCLog.i(TAG, "onConfEnded");
    }

    @Override
    public void onLeaveConf(int result) {
        HCLog.i(TAG, "onLeaveConf");
    }

    @Override
    public void onP2PConfRecord(HWMP2PConfRecordInfo p2pConfRecordInfo) {
        HCLog.i(TAG, "onP2PConfRecord");
    }

    @Override
    public void onConfStatusChanged(ConfStatus confStatus) {
        HCLog.i(TAG, "onConfStatusChanged, confStatus = " + confStatus.getDesc());
    }
}
