package com.huawei.hwmdemo.vision.dependency.menu.toolbar.handle;

import com.huawei.hwmdemo.menu.FloatingAttendeeToolbarMenuCreator;
import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IToolbarMenuStrategy;
import com.huawei.hwmdemo.dependency.menu.item.CustomMenu;
import com.huawei.hwmdemo.dependency.menu.item.VisionPairCodeMenu;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmsdk.NativeSDK;
import com.huawei.hwmsdk.enums.ConfMediaType;
import com.huawei.hwmsdk.model.result.MeetingInfo;

import java.util.ArrayList;
import java.util.List;

public class CustomVisionFloatingAttendeeToolbarHandle implements IToolbarMenuStrategy {
    @Override
    public List<IConfMenu> buildMenuItems() {
        if (!NativeSDK.getConfMgrApi().isInConf()) {
            return FloatingAttendeeToolbarMenuCreator.createFloatingAttendeeToolbarAllMenus(DemoUtil.getApplication());
        }
        return buildMenuItemsInConf();
    }

    @Override
    public List<IConfMenu> buildMoreMenuItems() {
        if (!NativeSDK.getConfMgrApi().isInConf()) {
            return buildAllMoreMenusItems();
        }
        return buildMoreMenuItemsInConf();
    }

    private List<IConfMenu> buildMenuItemsInConf() {
        List<IConfMenu> confMenus = FloatingAttendeeToolbarMenuCreator.createFloatingAttendeeToolbarInConfMenus(DemoUtil.getApplication());
        //增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    private List<IConfMenu> buildAllMoreMenusItems() {
        List<IConfMenu> confMenus = FloatingAttendeeToolbarMenuCreator.createFloatingAttendeeToolbarAllMoreMenus(DemoUtil.getApplication());
        confMenus.add(new VisionPairCodeMenu());
        //增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    private List<IConfMenu> buildMoreMenuItemsInConf() {
        boolean isVideoConf = false;
        MeetingInfo meetingInfo = NativeSDK.getConfStateApi().getMeetingInfo();
        if (meetingInfo != null) {
            isVideoConf = meetingInfo.getMediaType() == ConfMediaType.CONF_MEDIA_VIDEO;
        }
        List<IConfMenu> confMenus = FloatingAttendeeToolbarMenuCreator.createFloatingAttendeeToolbarInConfMoreMenus(DemoUtil.getApplication(), isVideoConf);
        confMenus.add(new VisionPairCodeMenu());
        //增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildSettingMenuItems() {
        return new ArrayList<>();
    }
}
