package com.huawei.hwmdemo.vision.dependency.menu.toolbar.wrapper;

import androidx.annotation.NonNull;

import com.huawei.hwmbiz.dependency.IFloatingToolBarMenuProxy;
import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IToolbarMenuStrategy;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.handle.CustomVisionFloatingToolbarHandle;

import java.util.ArrayList;
import java.util.List;

public class CustomVisionFloatingMenuHandleWrapper implements IFloatingToolBarMenuProxy {

    private final IFloatingToolBarMenuProxy handle = new CustomVisionFloatingToolbarHandle();

    @Override
    public IToolbarMenuStrategy getFloatingAttendeeToolbarMenuStrategy() {
        return new IToolbarMenuStrategy() {
            @Override
            public List<IConfMenu> buildMenuItems() {
                return filterMenus(handle.getFloatingAttendeeToolbarMenuStrategy().buildMenuItems(), "buildAttendeeMenuItems");
            }

            @Override
            public List<IConfMenu> buildMoreMenuItems() {
                return filterMenus(handle.getFloatingAttendeeToolbarMenuStrategy().buildMoreMenuItems(), "buildAttendeeMoreMenuItems");
            }

            @Override
            public List<IConfMenu> buildSettingMenuItems() {
                return new ArrayList<>();
            }
        };
    }

    @Override
    public IToolbarMenuStrategy getFloatingAudienceToolbarMenuStrategy() {
        return new IToolbarMenuStrategy() {
            @Override
            public List<IConfMenu> buildMenuItems() {
                return filterMenus(handle.getFloatingAudienceToolbarMenuStrategy().buildMenuItems(), "buildAudienceMenuItems");
            }

            @Override
            public List<IConfMenu> buildMoreMenuItems() {
                return filterMenus(handle.getFloatingAudienceToolbarMenuStrategy().buildMoreMenuItems(), "buildAudienceMoreMenuItems");
            }

            @Override
            public List<IConfMenu> buildSettingMenuItems() {
                return new ArrayList<>();
            }
        };
    }

    @NonNull
    private List<IConfMenu> filterMenus(List<IConfMenu> originMenus, String groupTag) {
        List<IConfMenu> confMenus = new ArrayList<>();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), groupTag, confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }
}
