package com.huawei.hwmdemo.delegate;

import android.app.Application;

import com.huawei.cloudlink.openapi.OpenSDKConfig;
import com.huawei.hwmdemo.delegate.mobile.MobileFeatureDelegate;
import com.huawei.hwmdemo.delegate.mobile.MobileSettingDelegate;
import com.huawei.hwmdemo.delegate.mobile.MobileUiDelegate;
import com.huawei.hwmdemo.vision.delegate.VisionFeatureDelegate;
import com.huawei.hwmdemo.vision.delegate.VisionSettingDelegate;
import com.huawei.hwmdemo.vision.delegate.VisionUiDelegate;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DelegateFactoryTest {


    @Test
    public void should_return_mobile_feature_delegate_when_not_rooms_mode() {
        Application app = Mockito.mock(Application.class);
        OpenSDKConfig openSDKConfig = new OpenSDKConfig(app);
        IHwmFeatureDelegate hwmFeatureDelegate = DelegateFactory.createHwmFeatureDelegate(app, openSDKConfig);
        Assert.assertTrue(hwmFeatureDelegate instanceof MobileFeatureDelegate);
    }

    @Test
    public void should_return_vision_feature_delegate_when_is_rooms_mode() {
        Application app = Mockito.mock(Application.class);
        OpenSDKConfig openSDKConfig = new OpenSDKConfig(app);
        openSDKConfig.setRoomsMode(true);
        IHwmFeatureDelegate hwmFeatureDelegate = DelegateFactory.createHwmFeatureDelegate(app, openSDKConfig);
        Assert.assertTrue(hwmFeatureDelegate instanceof VisionFeatureDelegate);
    }

    @Test
    public void should_return_mobile_setting_delegate_when_not_rooms_mode() {
        Application app = Mockito.mock(Application.class);
        OpenSDKConfig openSDKConfig = new OpenSDKConfig(app);
        IHwmSettingDelegate hwmSettingDelegate = DelegateFactory.createHwmSettingDelegate(app, openSDKConfig);
        Assert.assertTrue(hwmSettingDelegate instanceof MobileSettingDelegate);
    }

    @Test
    public void should_return_vision_setting_delegate_when_is_rooms_mode() {
        Application app = Mockito.mock(Application.class);
        OpenSDKConfig openSDKConfig = new OpenSDKConfig(app);
        openSDKConfig.setRoomsMode(true);
        IHwmSettingDelegate hwmSettingDelegate = DelegateFactory.createHwmSettingDelegate(app, openSDKConfig);
        Assert.assertTrue(hwmSettingDelegate instanceof VisionSettingDelegate);
    }

    @Test
    public void should_return_mobile_ui_delegate_when_not_rooms_mode() {
        Application app = Mockito.mock(Application.class);
        OpenSDKConfig openSDKConfig = new OpenSDKConfig(app);
        IHwmUiDelegate hwmUiDelegate = DelegateFactory.createHwmUiDelegate(app, openSDKConfig);
        Assert.assertTrue(hwmUiDelegate instanceof MobileUiDelegate);
    }

    @Test
    public void should_return_vision_ui_delegate_when_is_rooms_mode() {
        Application app = Mockito.mock(Application.class);
        OpenSDKConfig openSDKConfig = new OpenSDKConfig(app);
        openSDKConfig.setRoomsMode(true);
        IHwmUiDelegate hwmUiDelegate = DelegateFactory.createHwmUiDelegate(app, openSDKConfig);
        Assert.assertTrue(hwmUiDelegate instanceof VisionUiDelegate);
    }
}