package com.huawei.hwmdemo.view.sdk;

import android.text.TextUtils;

import com.huawei.cloudlink.openapi.api.param.LoginAuthType;
import com.huawei.cloudlink.openapi.api.param.LoginParam;
import com.huawei.hwmbiz.login.api.AppIdAuthParam;
import com.huawei.hwmfoundation.utils.StringUtil;

import org.junit.Assert;
import org.junit.Test;

/**
 * 【单元测试】检查SDK账号操作接口的参数有效性
 *
 * 可使用该测试类中的方法对SDK账号操作相关接口的入参进行单元测试，请确保调用接口时传入的参数能通过下方测试用例
 *
 * 具体接口文档请见：
 * https://support.huaweicloud.com/sdkreference-meeting/meeting_22_0129.html
 *
 */
public class AccountOperationApiParamTest {

    /**
     * 测试AppId有效性
     */
    @Test
    public void check_app_id() {
        // 替换此处变量为您的appId
        String appId = "fdb8e4699586458bbd10c834872dcc62";

        Assert.assertNotNull(appId);
        Assert.assertTrue(appId.length() <= 64);
        Assert.assertTrue(appId.length() > 0);
    }

    /**
     * 测试loginParam参数有效性
     *
     * @apiNote 登录 void login(LoginParam loginParam, HwmCallback<LoginResult> callback);
     */
    @Test
    public void check_LoginParam() {
        // 替换此处变量为传入的参数
        LoginParam loginParam = new LoginParam();

        // 参数验证
        Assert.assertNotNull(loginParam);
        Assert.assertFalse(loginParam.getLoginAuthType() == LoginAuthType.Huawei_Account_Accessoken);
    }

    /**
     * 测试AppIdAuthParam有效性
     *
     * @apiNote AppId登录: void loginByAppId(AppIdAuthParam appidAuthParam, HwmCallback<LoginResult> callback);
     */
    @Test
    public void check_AppIdAuthParam() {
        // 替换此处变量为传入的参数
        AppIdAuthParam appIdAuthParam = new AppIdAuthParam();

        // 参数验证
        Assert.assertNotNull(appIdAuthParam);
        Assert.assertTrue(appIdAuthParam.getExpireTime() >= 0);
        Assert.assertTrue(
            StringUtil.isEmpty(appIdAuthParam.getThirdUserId()) && appIdAuthParam.getThirdUserId().length() <= 64);
        Assert.assertTrue(appIdAuthParam.getNonce() != null && appIdAuthParam.getNonce().length() >= 32
            && appIdAuthParam.getNonce().length() <= 64);
        Assert.assertTrue(appIdAuthParam.getUserName() != null && appIdAuthParam.getUserName().length() <= 64);
        Assert.assertTrue(appIdAuthParam.getUserEmail() != null && appIdAuthParam.getUserEmail().length() <= 255);
        Assert.assertTrue(appIdAuthParam.getUserPhone() != null && appIdAuthParam.getUserPhone().length() <= 32);
    }

    /**
     * 测试上传头像的路径有效性
     *
     * @apiNote 上传头像: Observable<Integer> uploadHeadPortrait(String path)
     */
    @Test
    public void check_avatar_path() {
        // 替换此处变量为传入的参数
        String avatarPath = "test.png";

        // 参数验证
        Assert.assertFalse(TextUtils.isEmpty(avatarPath));
        Assert.assertTrue(avatarPath.endsWith("png") || avatarPath.endsWith("jpg"));
    }
}