package com.huawei.hwmdemo.menu;

import android.content.Context;

import com.huawei.cloudlink.smartrooms.uisdk.menu.CustomAddAttendeeMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.MicMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.MinimizeMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.MoreMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.ParticipantMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.SettingMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.ShareMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.SubtitlesMenu;
import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;

import java.util.ArrayList;
import java.util.List;

public class ConfAudioToolbarMenuCreator {

    public static List<IConfMenu> createConfAudioToolbarMenus(Context context, boolean isCustomAddAttendeeMenuSupported) {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new MicMenu(context));
        confMenus.add(new ShareMenu(context));
        confMenus.add(new ParticipantMenu(context));
        //自定义加人
        if (isCustomAddAttendeeMenuSupported) {
            confMenus.add(new CustomAddAttendeeMenu(context));
        }
        confMenus.add(new MoreMenu(context));
        return confMenus;
    }

    public static List<IConfMenu> createConfAudioToolbarMoreMenus(Context context, boolean isCustomAddAttendeeMenuSupported) {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new SubtitlesMenu(context));
        confMenus.add(new SettingMenu(context));
        confMenus.add(new MinimizeMenu(context));
        //自定义加人
        if (isCustomAddAttendeeMenuSupported) {
            confMenus.add(new CustomAddAttendeeMenu(context));
        }
        return confMenus;
    }
}
