package com.huawei.hwmdemo.delegate;

import android.app.Application;

import com.huawei.cloudlink.openapi.OpenSDKConfig;
import com.huawei.hwmdemo.delegate.mobile.MobileFeatureDelegate;
import com.huawei.hwmdemo.delegate.mobile.MobileSettingDelegate;
import com.huawei.hwmdemo.delegate.mobile.MobileUiDelegate;
import com.huawei.hwmdemo.vision.delegate.VisionFeatureDelegate;
import com.huawei.hwmdemo.vision.delegate.VisionSettingDelegate;
import com.huawei.hwmdemo.vision.delegate.VisionUiDelegate;
import com.huawei.hwmlogger.HCLog;

public class DelegateFactory {

    private static final String TAG = "DelegateFactory";

    public static IHwmUiDelegate createHwmUiDelegate(Application application, OpenSDKConfig sdkConfig) {
        IHwmUiDelegate uiDelegate;
        if (sdkConfig.isRoomsMode()) {
            uiDelegate = new VisionUiDelegate(application);
        } else {
            uiDelegate = new MobileUiDelegate(application);
        }
        HCLog.i(TAG, " createHwmUiDelegate : " + uiDelegate);
        return uiDelegate;
    }

    public static IHwmSettingDelegate createHwmSettingDelegate(Application application, OpenSDKConfig sdkConfig) {
        IHwmSettingDelegate settingDelegate;
        if (sdkConfig.isRoomsMode()) {
            settingDelegate = new VisionSettingDelegate(application);
        } else {
            settingDelegate = new MobileSettingDelegate(application);
        }
        HCLog.i(TAG, " createHwmSettingDelegate : " + settingDelegate);
        return settingDelegate;
    }

    public static IHwmFeatureDelegate createHwmFeatureDelegate(Application application, OpenSDKConfig sdkConfig) {
        IHwmFeatureDelegate featureDelegate;
        if (sdkConfig.isRoomsMode()) {
            featureDelegate = new VisionFeatureDelegate(application);
        } else {
            featureDelegate = new MobileFeatureDelegate(application);
        }
        HCLog.i(TAG, " createHwmFeatureDelegate : " + featureDelegate);
        return featureDelegate;
    }
}
