package com.huawei.hwmdemo.delegate.mobile;

import android.app.Application;

import com.huawei.hwmdemo.delegate.IHwmSettingDelegate;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.encryptdemo.HwmEncryptionDemo;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmlogger.HCLog;
import com.huawei.hwmprivatesdk.PrivateNativeSDK;
import com.huawei.hwmsdk.enums.SDKERR;

public class MobileSettingDelegate implements IHwmSettingDelegate {

    private static final String TAG = "MobileSettingDelegate";

    private final Application application;

    public MobileSettingDelegate(Application application) {
        this.application = application;
    }

    @Override
    public void initSettingConfig() {
        configE2E();
        configDisableMenu();
    }

    private void configDisableMenu() {
        DemoUtil.initDisabledMenuConfig(application);
    }

    private void configE2E() {
        if (DemoUtil.needCustom(NeedCustomType.ENABLE_E2E_ENCRYPT)) {
            HwmEncryptionDemo.getInstance().setEncryption();
            SDKERR code = PrivateNativeSDK.getPrivateDeviceMgrApi().enableE2EE(true);
            HCLog.i(TAG, " configE2E result : " + code.getValue());
        }
    }
}
