package com.huawei.hwmdemo.delegate.mobile;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.huawei.cloudlink.openapi.OpenSDKConfig;
import com.huawei.cloudlink.openapi.model.HWMEnableFeatureType;
import com.huawei.cloudlink.smartrooms.openapi.api.IServerSettingStrategy;
import com.huawei.conflogic.HwmAttendeeInfo;
import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmbiz.contact.cache.model.CorporateContactInfoModel;
import com.huawei.hwmbiz.contact.model.HWMConfQueryContactModel;
import com.huawei.hwmbiz.dependency.IServerCaHandle;
import com.huawei.hwmbiz.dependency.ISiteTypeStrategy;
import com.huawei.hwmbiz.login.model.LoginSetting;
import com.huawei.hwmbiz.setting.SiteType;
import com.huawei.hwmchat.model.AnswerBtnShowType;
import com.huawei.hwmconf.presentation.dependency.IDeviceStrategyWhenConfAccept;
import com.huawei.hwmconf.presentation.dependency.IHideExternalLabelHandle;
import com.huawei.hwmconf.presentation.dependency.IInMeetingDifferenceHandle;
import com.huawei.hwmconf.presentation.dependency.IIncomingHandle;
import com.huawei.hwmconf.presentation.dependency.IUiStrategyWhenConfIncoming;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IAudienceMenuStrategy;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IParticipantMenuStrategy;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IToolbarMenuStrategy;
import com.huawei.hwmconf.presentation.dependency.menu.v2.buildin.toolbar.ToolBarMenuProxy;
import com.huawei.hwmconf.presentation.model.HWMIncomingAnswerType;
import com.huawei.hwmconf.sdk.model.call.entity.CallInfo;
import com.huawei.hwmdemo.constant.ConfigConstant;
import com.huawei.hwmdemo.delegate.IHwmUiDelegate;
import com.huawei.hwmdemo.dependency.CustomAccountEventHandle;
import com.huawei.hwmdemo.dependency.CustomAddAttendeesHandle;
import com.huawei.hwmdemo.dependency.CustomBizNotificationHandle;
import com.huawei.hwmdemo.dependency.CustomConfLeaveConfPopwindowHandle;
import com.huawei.hwmdemo.dependency.CustomConfLinkHandle;
import com.huawei.hwmdemo.dependency.CustomConfTitleBarPopwindowHandle;
import com.huawei.hwmdemo.dependency.CustomFloatingWindowHandle;
import com.huawei.hwmdemo.dependency.CustomIUiCustomImageHandler;
import com.huawei.hwmdemo.dependency.CustomIUiCustomTextHandler;
import com.huawei.hwmdemo.dependency.CustomInMeetingChatStrategy;
import com.huawei.hwmdemo.dependency.CustomLoggerHandle;
import com.huawei.hwmdemo.dependency.CustomNotifyHandler;
import com.huawei.hwmdemo.dependency.CustomParticipantCallOtherNumbers;
import com.huawei.hwmdemo.dependency.CustomPushExternalVideoFrameStrategy;
import com.huawei.hwmdemo.dependency.CustomQueryContactInfoStrategy;
import com.huawei.hwmdemo.dependency.CustomShareHandle;
import com.huawei.hwmdemo.dependency.CustomUiConfigChangeHandler;
import com.huawei.hwmdemo.dependency.CustomVirtualBackgroundHandle;
import com.huawei.hwmdemo.dependency.CustomWatermarkHandle;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.dependency.NotificationStrategy;
import com.huawei.hwmdemo.dependency.menu.CustomShareInterceptHandle;
import com.huawei.hwmdemo.dependency.menu.audience.CustomAudienceMenuHandle;
import com.huawei.hwmdemo.dependency.menu.participant.CustomParticipantMenuHandle;
import com.huawei.hwmdemo.dependency.menu.statusbar.wrapper.CustomStatusBarMenuHandleWrapper;
import com.huawei.hwmdemo.dependency.menu.toolbar.handle.CustomConfAudioToolbarHandle;
import com.huawei.hwmdemo.dependency.menu.toolbar.handle.CustomConfVideoToolbarHandle;
import com.huawei.hwmdemo.dependency.menu.toolbar.handle.CustomConfWebinarToolbarHandle;
import com.huawei.hwmdemo.dependency.menu.toolbar.listener.CustomOnMenuItemClickListener;
import com.huawei.hwmdemo.dependency.menu.toolbar.wrapper.mobile.CustomAudienceMenuHandleWrapper;
import com.huawei.hwmdemo.dependency.menu.toolbar.wrapper.mobile.CustomConfAudioToolbarHandleWrapper;
import com.huawei.hwmdemo.dependency.menu.toolbar.wrapper.mobile.CustomConfVideoToolbarHandleWrapper;
import com.huawei.hwmdemo.dependency.menu.toolbar.wrapper.mobile.CustomConfWebinarToolbarHandleWrapper;
import com.huawei.hwmdemo.dependency.menu.toolbar.wrapper.mobile.CustomParticipantMenuHandleWrapper;
import com.huawei.hwmdemo.model.ApiPageModel;
import com.huawei.hwmdemo.model.FeaturePage;
import com.huawei.hwmdemo.model.MenuGroup;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.utils.PreferencesUtil;
import com.huawei.hwmdemo.view.scheme.SchemeListFragment;
import com.huawei.hwmdemo.view.scheme.StateApiFragment;
import com.huawei.hwmdemo.view.sdk.AppIdLoginFragment;
import com.huawei.hwmdemo.view.sdk.BookCycleMeetingFragment;
import com.huawei.hwmdemo.view.sdk.BookMeetingFragment;
import com.huawei.hwmdemo.view.sdk.CreateMeetingFragment;
import com.huawei.hwmdemo.view.sdk.CustomVrBgDefaultImageFragment;
import com.huawei.hwmdemo.view.sdk.DeployInfoConfigPFragment;
import com.huawei.hwmdemo.view.sdk.GlobalGuaranteedIPFragment;
import com.huawei.hwmdemo.view.sdk.GuaranteedAddressesSettingFragment;
import com.huawei.hwmdemo.view.sdk.IncomingNotificationFragment;
import com.huawei.hwmdemo.view.sdk.JoinMeetingFragment;
import com.huawei.hwmdemo.view.sdk.LanguageSettingFragment;
import com.huawei.hwmdemo.view.sdk.ListMeetingFragment;
import com.huawei.hwmdemo.view.sdk.ListVmrIdFragment;
import com.huawei.hwmdemo.view.sdk.LogPathFragment;
import com.huawei.hwmdemo.view.sdk.MeetingInfoFragment;
import com.huawei.hwmdemo.view.sdk.NormalLoginFragment;
import com.huawei.hwmdemo.view.sdk.OfflineControllerFragment;
import com.huawei.hwmdemo.view.sdk.P2PConfFragment;
import com.huawei.hwmdemo.view.sdk.ProjectionInConfFragment;
import com.huawei.hwmdemo.view.sdk.QuickAnonymousJoinMeetingFragment;
import com.huawei.hwmdemo.view.sdk.SDKListFragment;
import com.huawei.hwmdemo.view.sdk.SelectModeFragment;
import com.huawei.hwmdemo.view.sdk.ServerSettingFragment;
import com.huawei.hwmdemo.view.sdkconfig.CustomizeListFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.AudienceMenuConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.AudioConfToolbarMenuConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.ParticipantMenuConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.StatusBarMenuConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.VideoConfToolbarMenuConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.WebinarConfToolbarMenuConfigFragment;
import com.huawei.hwmdemo.vision.utils.ModeUtil;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmfoundation.utils.FileUtil;
import com.huawei.hwmfoundation.utils.PreferenceUtils;
import com.huawei.hwmsdk.enums.NetworkAccessType;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.rxjava3.core.Observable;

public class MobileUiDelegate implements IHwmUiDelegate {

    private final Application application;

    public MobileUiDelegate(Application application) {
        this.application = application;
    }

    @Override
    public void initOpenSdkUIConfig(OpenSDKConfig sdkConfig) {

        //自定义接入站点
        configCustomSiteTypeStrategy(sdkConfig);

        //自定义加人
        configCustomAddAttendee(sdkConfig);

        //自定义账号被踢
        configCustomKickOut(sdkConfig);

        //自定义分享菜单
        configCustomShare(sdkConfig);

        //自定义会中分享链接
        configShareLink(sdkConfig);

        //自定义功能启用或屏蔽
        configFeature(sdkConfig);

        //自定义会中水印
        configWaterMark(sdkConfig);

        //自定义会中通知栏
        configCustomNotification(sdkConfig);

        //自定义会中一些逻辑层原始数据的通知
        configCustomBizNotification(sdkConfig);

        //自定义会中ui行为通知
        configCustomNotifyHandle(sdkConfig);

        //自定义系统配置变更行为通知
        configCustomUiConfigChangeHandle(sdkConfig);

        //自定义日志路径
        configCustomLogHandle(sdkConfig);

        //自定义来电处理
        configCustomInComingHandle(sdkConfig);

        //自定义菜单
        configCustomMenu(sdkConfig);

        //自定义外部标签显示
        configCustomHideExternalLabelHandle(sdkConfig);

        //自定义点击离会按钮悬浮窗弹框
        configCustomConfLeaveConfPopwindowHandle(sdkConfig);

        //自定义会中录制功能弹窗文案
        configUiCustomTextHandle(sdkConfig);

        // 自定义会中图标
        configUiCustomImageHandle(sdkConfig);

        //自定义会中标题栏的点击
        if (DemoUtil.needCustom(NeedCustomType.CONF_TITLE_BAR_POPWINDOW)) {
            sdkConfig.setConfTitlePopwindowHandle(new CustomConfTitleBarPopwindowHandle());
        }

        if (DemoUtil.needCustom(NeedCustomType.HIDE_ATTENDEE_HAS_LEFT_CONF)) {
            sdkConfig.setHideAttendeeHasLeftConf(true);
        }
        sdkConfig.setHighResolutionFirst(DemoUtil.needCustom(NeedCustomType.HIGH_RESOLUTION_FIRST));

        //第三方码流注入策略
        if (DemoUtil.needCustom(NeedCustomType.ENABLE_EXTERNAL_CAPTURE)) {
            sdkConfig.setPushExternalVideoFrameStrategy(new CustomPushExternalVideoFrameStrategy());
        }

        //第三方自定义会中头像显示
        if (DemoUtil.needCustom(NeedCustomType.SHOW_CUSTOM_AVATAR)) {
            sdkConfig.setQueryContactAvatarStrategy(new CustomQueryContactInfoStrategy(application.getResources()));
        }

        sdkConfig.setDeviceStrategyWhenConfAccept(new IDeviceStrategyWhenConfAccept() {

            @Override
            public boolean isTurnOnCameraWhenConfAccept() {
                return DemoUtil.needCustom(NeedCustomType.CONF_OPEN_CAMERA);
            }

            @Override
            public boolean isTurnOnMicWhenConfAccept() {
                return DemoUtil.needCustom(NeedCustomType.CONF_OPEN_MIC);
            }
        });

        if (DemoUtil.needCustom(NeedCustomType.SITE_TYPE_STRATEGY)) {
            sdkConfig.setSiteTypeStrategy(new ISiteTypeStrategy() {
                @Override
                public SiteType getSiteType() {
                    return SiteType.SITE_TYPE_HEC_AP;
                }
            });
        } else {
            sdkConfig.setSiteTypeStrategy(new ISiteTypeStrategy() {
                @Override
                public SiteType getSiteType() {
                    return SiteType.SITE_TYPE_HEC_CN;
                }
            });
        }

        //是否隐藏语音接听，视频接听
        sdkConfig.setUiStrategyWhenConfIncoming(new IUiStrategyWhenConfIncoming() {
            @Override
            public AnswerBtnShowType getVideoConfIncomingAnswerBtnShowType() {
                if (DemoUtil.needCustom(NeedCustomType.CONF_HIDDEN_ACCEPT_AUDIO)) {
                    return AnswerBtnShowType.AnswerBtnShowTypeOnlyVideo;
                } else if (DemoUtil.needCustom(NeedCustomType.CONF_HIDDEN_ACCEPT_VIDEO)) {
                    return AnswerBtnShowType.AnswerBtnShowTypeOnlyAudio;
                } else {
                    return AnswerBtnShowType.AnswerBtnShowTypeAll;
                }
            }
        });

        //日志保存天数，0为使用SDK内部策略，非0情况范围3-30
        if (DemoUtil.needCustom(NeedCustomType.LOG_KEEP_DAYS)) {
            String value = PreferencesUtil.getStringPreference(application, ConfigConstant.KEY_LOG_KEEP_DAYS, "0");
            sdkConfig.setLogKeepDays(Integer.parseInt(value));
        }
        //不允许用户自定义虚拟背景图片
        if (DemoUtil.needCustom(NeedCustomType.NOT_ALLOW_USER_CUSTOM_IMAGE)) {
            sdkConfig.enableFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_CUSTOM_VIRTUALBG_IMAGE, false);
        }
        //会中支持遥控器操作
        if (DemoUtil.needCustom(NeedCustomType.SUPPORT_REMOTE_CONTROL)) {
            sdkConfig.setRemoteControlMode(true);
        }
        //支持断开音频入会功能
        if (DemoUtil.needCustom(NeedCustomType.SUPPORT_DISCONNECT_AUDIO)) {
            sdkConfig.enableFeature(HWMEnableFeatureType.HWM_ENABLE_FEATURE_SUPPORT_DISCONNECT_AUDIO, true);
        }
        // 自定义音视频悬浮窗通知
        if (DemoUtil.needCustom(NeedCustomType.FLOATING_WINDOW_HANDLE)) {
            sdkConfig.setFloatingWindowHandle(new CustomFloatingWindowHandle());
        }

        configVirtualBackgroundHandle(sdkConfig);
        configInterruptShareHandle(sdkConfig);
        configParticipantCallOtherNumbersHandle(sdkConfig);
        configInMeetingDifferenceHandle(sdkConfig);
    }

    private void configCustomSiteTypeStrategy(OpenSDKConfig sdkConfig) {

        sdkConfig.setServerCaHandle(new IServerCaHandle() {
            @Override
            public boolean isVerified() {
                return DemoUtil.needCustom(NeedCustomType.SITE_CA_CHECK);
            }

            @Override
            public String getCaPath() {
                return isVerified() ? FileUtil.getFileDirPath(DemoUtil.getApplication()) : "";
            }
        });

        sdkConfig.setSiteTypeStrategy(new ISiteTypeStrategy() {
            @Override
            public SiteType getSiteType() {
                return DemoUtil.needCustom(NeedCustomType.SITE_TYPE_STRATEGY)
                        ? SiteType.SITE_TYPE_HEC_AP
                        : SiteType.SITE_TYPE_HEC_CN;
            }
        });

        // 自定义站点 和 代理模式
        if (!TextUtils.isEmpty(DemoUtil.getCustomSiteAddress()) && DemoUtil.getCustomSitePort() != 0) {
            sdkConfig.setServerSettingStrategy(new IServerSettingStrategy() {
                @Override
                public String getServerAddress() {
                    return DemoUtil.getCustomSiteAddress();
                }

                @Override
                public int getServerPort() {
                    return DemoUtil.getCustomSitePort();
                }

                @Override
                public NetworkAccessType getProxyType() {
                    return DemoUtil.getCustomSiteProxy();
                }
            });
        }
    }

    @Override
    public int getScreenOrientation() {
        return ActivityInfo.SCREEN_ORIENTATION_PORTRAIT;
    }

    private void configCustomAddAttendee(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.ADD_ATTENDEES)) {
            sdkConfig.setAddAttendeesHandle(new CustomAddAttendeesHandle());
        }
    }

    private void configCustomKickOut(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.ACCOUNT_EVENT_HANDLE)) {
            sdkConfig.setAccountEventHandle(new CustomAccountEventHandle());
        }
    }


    private void configCustomShare(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.SHARE_MENU)) {
            sdkConfig.setShareHandle(new CustomShareHandle());
        }
    }

    @Deprecated
    private void configShareLink(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.SHARE_LINK)) {
            sdkConfig.setConfLinkHandle(new CustomConfLinkHandle());
        }
    }

    private void configFeature(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.FEATURE_CONFIG)) {
            List<HWMEnableFeatureType> checkedCapabilities = DemoUtil.queryCheckedCapabilities();
            if (checkedCapabilities != null) {
                for (HWMEnableFeatureType type : checkedCapabilities) {
                    //启用功能
                    if (type == HWMEnableFeatureType.HWM_FEATURE_TYPE_CONFIRM_RECORD) {
                        sdkConfig.enableFeature(type, true);
                        continue;
                    }
                    if (type == HWMEnableFeatureType.HWM_FEATURE_TYPE_SAVE_NICK_NAME_WHEN_ANONYMOUS_JOIN) {
                        sdkConfig.enableFeature(type, true);
                        continue;
                    }
                    //屏蔽功能
                    sdkConfig.enableFeature(type, false);
                }
            }
        }
    }

    private void configWaterMark(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.WATER_MARK)) {
            sdkConfig.setWatermarkHandle(new CustomWatermarkHandle());
        }
    }

    private void configCustomNotification(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.CONF_NOTIFICATION_DIFFERENCE)) {
            sdkConfig.setNotificationStrategy(new NotificationStrategy());
        }
    }

    private void configCustomBizNotification(OpenSDKConfig sdkConfig) {
        //demo 需要缓存会中状态
        sdkConfig.setBizNotificationHandler(new CustomBizNotificationHandle());
    }

    private void configCustomNotifyHandle(OpenSDKConfig sdkConfig) {
        //demo 需要缓存会中状态
        sdkConfig.setNotifyHandler(new CustomNotifyHandler());

    }

    private void configCustomUiConfigChangeHandle(OpenSDKConfig sdkConfig) {
        sdkConfig.setUiConfigChangeHandler(new CustomUiConfigChangeHandler());
    }

    private void configCustomLogHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.LOGGER_PATH)) {
            sdkConfig.setLoggerHandle(new CustomLoggerHandle(application));
        }
    }

    private void configCustomHideExternalLabelHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.HIDE_EXTERNAL_LABEL)) {
            sdkConfig.setHideExternalLabelHandle(new IHideExternalLabelHandle() {
                @Override
                public boolean onHideExternalLabelEvent() {
                    return DemoUtil.needCustom(NeedCustomType.HIDE_EXTERNAL_LABEL);
                }
            });
        }
    }

    private void configCustomConfLeaveConfPopwindowHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.CONF_LEAVE_CONF_POPWINDOW)) {
            sdkConfig.setConfLeaveConfPopwindowHandle(new CustomConfLeaveConfPopwindowHandle());
        }
    }

    private void configUiCustomTextHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.CONF_UI_CUSTOM_TEXT)) {
            sdkConfig.setUiCustomTextHandler(new CustomIUiCustomTextHandler());
        }
    }

    private void configUiCustomImageHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.CONF_UI_CUSTOM_IMAGE)) {
            sdkConfig.setUiCustomImageHandler(new CustomIUiCustomImageHandler());
        }
    }

    private void configVirtualBackgroundHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.CUSTOM_VIRTUAL_BACKGROUND)) {
            sdkConfig.setVirtualBackgroundHandle(new CustomVirtualBackgroundHandle());
        }
    }

    private void configInterruptShareHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.CUSTOM_INTERRUPT_SHARE)) {
            sdkConfig.setShareInterceptHandle(new CustomShareInterceptHandle());
        }
    }

    private void configParticipantCallOtherNumbersHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.CUSTOM_CALL_OTHER_NUMBERS)) {
            sdkConfig.setParticipantCallOtherNumberStrategy(new CustomParticipantCallOtherNumbers());
        }
    }

    private void configInMeetingDifferenceHandle(OpenSDKConfig sdkConfig) {
        sdkConfig.setInMeetingDifferenceHandle(new IInMeetingDifferenceHandle() {
            @Override
            public void prepareForConf(Bundle parms, Intent curIntent) {

            }

            @Override
            public void prepareForCall(Activity curActivity) {

            }

            @Override
            public void beforeTransToConf(List<HwmAttendeeInfo> ckAttendees, HwmCallback<String> callback) {

            }

            @Override
            public Observable<CorporateContactInfoModel> queryUserDetail(HWMConfQueryContactModel queryContactModel) {
                // 下沉模式 云会议不支持查询联系人
                if (LoginSetting.isSinkMode()) {
                    return Observable.create(emitter -> {
                        CorporateContactInfoModel contactInfoModel = new CorporateContactInfoModel();
                        if (queryContactModel != null && !TextUtils.isEmpty(queryContactModel.getNumber())) {
                            contactInfoModel.setMobile(queryContactModel.getNumber());
                        }
                        emitter.onNext(contactInfoModel);
                    });
                }
                return HWMBizSdk.getCorporateContactInfoApi().queryUserDetailByNumber(queryContactModel.getNumber());
            }

            @Override
            public void beforeIncomingCall(String callerAccount, Boolean isVideoCall) {

            }

            @Override
            public void beforeIncomingConf(String callerAccount, Boolean isVideoConf) {

            }

            @Override
            public void afterCallEnded(CallInfo callInfo) {

            }

            @Override
            public void setCurrentCallState(Boolean isCalling) {

            }

            @Override
            public void doLeaveFromAnonymouse() {

            }

            @Override
            public void dealAnonymouseErrorInfo(boolean isDealError) {

            }

            @Override
            public boolean defaultFirstUse() {
                return true;
            }

            @Override
            public boolean isDisableLeaveConfUIWhenAnonymousJoin() {
                return true;
            }

            @Override
            public CharSequence getPrivacyAndService() {
                return null;
            }
        });
    }

    private void configCustomInComingHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.SHOW_CUSTOM_INCOMING)) {
            sdkConfig.setInComingHandle(new IIncomingHandle() {
                @Override
                public HWMIncomingAnswerType answerTypeOnCallIncoming() {
                    return HWMIncomingAnswerType.valueOf(PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_INCOMING_CALL,
                            HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType(), application));
                }

                @Override
                public HWMIncomingAnswerType answerTypeOnConfIncoming() {
                    return HWMIncomingAnswerType.valueOf(PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_INCOMING_CONF,
                            HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType(), application));
                }
            });
        }
    }

    private void configCustomMenu(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.CONF_MENU)) {
            ToolBarMenuProxy toolBarMenuProxy = new ToolBarMenuProxy();
            //定制 音频会议的会中toolbar菜单
            toolBarMenuProxy.setConfAudioToolbarHandle(new CustomConfAudioToolbarHandleWrapper());
            //定制 视频会议的会中toolbar菜单
            toolBarMenuProxy.setConfVideoToolbarHandle(new CustomConfVideoToolbarHandleWrapper());
            //定制 网络研讨会的会中toolbar菜单
            toolBarMenuProxy.setConfWebinarToolbarHandle(new CustomConfWebinarToolbarHandleWrapper());
            sdkConfig.setToolBarMenuProxy(toolBarMenuProxy);
            //定制会中入会者列表界面的菜单
            sdkConfig.setParticipantMenuStrategy(new CustomParticipantMenuHandleWrapper());
            // 定制会中观众列表界面的菜单
            sdkConfig.setAudienceMenuStrategy(new CustomAudienceMenuHandleWrapper());
            //自定义菜单的点击事件处理
            sdkConfig.setOnMenuItemClickListener(new CustomOnMenuItemClickListener());

            //定制会中状态栏界面的菜单
            sdkConfig.setStatusBarMenuStrategy(new CustomStatusBarMenuHandleWrapper());

            //非UI定制，内部功能定制-自定义菜单开启会中消息二进制通道
            sdkConfig.setInMeetingChatStrategy(new CustomInMeetingChatStrategy());
        }
    }

    @NonNull
    @Override
    public List<FeaturePage> getHomePages() {
        List<FeaturePage> pages = new ArrayList<>();
        pages.add(new FeaturePage("SDK集成Demo", new SDKListFragment()));
        pages.add(new FeaturePage("自定义拓展功能Demo", new CustomizeListFragment()));
        pages.add(new FeaturePage("链接调用Demo", new SchemeListFragment()));
        pages.add(new FeaturePage("状态类API接口调用Demo", new StateApiFragment()));
        return pages;
    }

    @NonNull
    @Override
    public List<ApiPageModel> getSdkApiFeatures() {
        List<ApiPageModel> features = new ArrayList<>();
        if (ModeUtil.getSupportedModeTypes().size() >= 2) {
            features.add(new ApiPageModel("模式切换", SelectModeFragment.class));
        }
        features.add(new ApiPageModel("服务器设置", ServerSettingFragment.class));
        features.add(new ApiPageModel("会控保底地址设置", GuaranteedAddressesSettingFragment.class));
        features.add(new ApiPageModel("管理面保底IP设置", GlobalGuaranteedIPFragment.class));
        features.add(new ApiPageModel("云上云下部署模式", DeployInfoConfigPFragment.class));
        features.add(new ApiPageModel("登录", NormalLoginFragment.class));
        features.add(new ApiPageModel("AppId登录", AppIdLoginFragment.class));
        features.add(new ApiPageModel("SSO登录", null));
        features.add(new ApiPageModel("预约会议", BookMeetingFragment.class));
        features.add(new ApiPageModel("预约周期会议", BookCycleMeetingFragment.class));
        features.add(new ApiPageModel("创建会议", CreateMeetingFragment.class));
        features.add(new ApiPageModel("加入会议", JoinMeetingFragment.class));
        features.add(new ApiPageModel("快速匿名入会", QuickAnonymousJoinMeetingFragment.class));
        features.add(new ApiPageModel("立即会议", P2PConfFragment.class));
        features.add(new ApiPageModel("会中投屏", ProjectionInConfFragment.class));
        features.add(new ApiPageModel("会议列表", ListMeetingFragment.class));
        features.add(new ApiPageModel("云会议室列表", ListVmrIdFragment.class));
        features.add(new ApiPageModel("来电通知", IncomingNotificationFragment.class));
        features.add(new ApiPageModel("用户状态", null));
        features.add(new ApiPageModel("会议信息", MeetingInfoFragment.class));
        features.add(new ApiPageModel("设置头像", null));
        features.add(new ApiPageModel("修改自定义日志路径", LogPathFragment.class));
        features.add(new ApiPageModel("控制器配对（离线）", OfflineControllerFragment.class));
        features.add(new ApiPageModel("控制器配对（在线）", null));
        features.add(new ApiPageModel("自定义虚拟背景默认图片", CustomVrBgDefaultImageFragment.class));
        features.add(new ApiPageModel("自定义语言", LanguageSettingFragment.class));
        features.add(new ApiPageModel("拉起会中主界面", null));
        features.add(new ApiPageModel("获取登录信息", null));
        features.add(new ApiPageModel("登出", null));
        return features;
    }

    @NonNull
    @Override
    public List<FeaturePage> getMenuConfigPages() {
        List<FeaturePage> pages = new ArrayList<>();
        StatusBarMenuConfigFragment statusBarMenuConfigFragment = new StatusBarMenuConfigFragment();
        pages.add(new FeaturePage(statusBarMenuConfigFragment.getName(), statusBarMenuConfigFragment));
        VideoConfToolbarMenuConfigFragment videoConfToolbarMenuConfigFragment = new VideoConfToolbarMenuConfigFragment();
        pages.add(new FeaturePage(videoConfToolbarMenuConfigFragment.getName(), videoConfToolbarMenuConfigFragment));
        AudioConfToolbarMenuConfigFragment audioConfToolbarMenuConfigFragment = new AudioConfToolbarMenuConfigFragment();
        pages.add(new FeaturePage(audioConfToolbarMenuConfigFragment.getName(), audioConfToolbarMenuConfigFragment));
        WebinarConfToolbarMenuConfigFragment webinarConfToolbarMenuConfigFragment = new WebinarConfToolbarMenuConfigFragment();
        pages.add(new FeaturePage(webinarConfToolbarMenuConfigFragment.getName(), webinarConfToolbarMenuConfigFragment));
        ParticipantMenuConfigFragment participantMenuConfigFragment = new ParticipantMenuConfigFragment();
        pages.add(new FeaturePage(participantMenuConfigFragment.getName(), participantMenuConfigFragment));
        AudienceMenuConfigFragment audienceMenuConfigFragment = new AudienceMenuConfigFragment();
        pages.add(new FeaturePage(audienceMenuConfigFragment.getName(), audienceMenuConfigFragment));
        return pages;
    }

    @NonNull
    @Override
    public List<MenuGroup> getVideoMeetingMenuFeatures() {
        IToolbarMenuStrategy strategy = new CustomConfVideoToolbarHandle();
        List<MenuGroup> features = new ArrayList<>();
        features.add(new MenuGroup("底部菜单项", "buildMenuItems", strategy.buildMenuItems()));
        features.add(new MenuGroup("更多菜单项", "buildMoreMenuItems", strategy.buildMoreMenuItems()));
        features.add(new MenuGroup("设置菜单项", "buildSettingMenuItems", strategy.buildSettingMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getVideoMeetingMenuHandle() {
        return CustomConfVideoToolbarHandle.class.getName();
    }

    @NonNull
    @Override
    public List<MenuGroup> getAudioMeetingMenuFeatures() {
        IToolbarMenuStrategy strategy = new CustomConfAudioToolbarHandle();
        List<MenuGroup> features = new ArrayList<>();
        features.add(new MenuGroup("底部菜单项", "buildMenuItems", strategy.buildMenuItems()));
        features.add(new MenuGroup("更多菜单项", "buildMoreMenuItems", strategy.buildMoreMenuItems()));
        features.add(new MenuGroup("设置菜单项", "buildSettingMenuItems", strategy.buildSettingMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getAudioMeetingMenuHandle() {
        return CustomConfAudioToolbarHandle.class.getName();
    }

    @NonNull
    @Override
    public List<MenuGroup> getWebinarMeetingMenuFeatures() {
        IToolbarMenuStrategy strategy = new CustomConfWebinarToolbarHandle();
        List<MenuGroup> features = new ArrayList<>();
        features.add(new MenuGroup("底部菜单项", "buildMenuItems", strategy.buildMenuItems()));
        features.add(new MenuGroup("更多菜单项", "buildMoreMenuItems", strategy.buildMoreMenuItems()));
        features.add(new MenuGroup("设置菜单项", "buildSettingMenuItems", strategy.buildSettingMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getWebinarMeetingMenuHandle() {
        return CustomConfWebinarToolbarHandle.class.getName();
    }

    @NonNull
    @Override
    public List<MenuGroup> getParticipantMenuFeatures() {
        IParticipantMenuStrategy strategy = new CustomParticipantMenuHandle();
        List<MenuGroup> features = new ArrayList<>();
        features.add(new MenuGroup("右上角菜单栏", "buildParticipantMoreMenuItems", strategy.buildParticipantMoreMenuItems()));
        features.add(new MenuGroup("点击与会者弹窗菜单", "buildParticipantItemMenuItems", strategy.buildParticipantItemMenuItems()));
        features.add(new MenuGroup("底部与会者菜单栏", "buildParticipantToolbarMenuItems", strategy.buildParticipantToolbarMenuItems()));
        features.add(new MenuGroup("底部等候室菜单栏", "buildWaitingToolbarMenuItems", strategy.buildWaitingToolbarMenuItems()));
        features.add(new MenuGroup("底部未入会菜单栏", "buildUnJoinedToolbarMenuItems", strategy.buildUnJoinedToolbarMenuItems()));
        features.add(new MenuGroup("点击底部更多弹窗菜单", "buildParticipantToolbarMoreMenuItems", strategy.buildParticipantToolbarMoreMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getParticipantMenuHandle() {
        return CustomParticipantMenuHandle.class.getName();
    }

    @NonNull
    @Override
    public List<MenuGroup> getAudienceMenuFeatures() {
        IAudienceMenuStrategy strategy = new CustomAudienceMenuHandle();
        List<MenuGroup> features = new ArrayList<>();
        features.add(new MenuGroup("点击观众弹窗菜单", "buildAudienceItemMenuItems", strategy.buildAudienceItemMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getAudienceMenuHandle() {
        return CustomAudienceMenuHandle.class.getName();
    }

    @NonNull
    @Override
    public List<MenuGroup> getFloatingMenuFeatures() {
        return new ArrayList<>();
    }

    @NonNull
    @Override
    public String getFloatingMenuHandle() {
        return "";
    }
}
