package com.huawei.hwmdemo.dependency;

import android.view.ViewGroup;

import com.huawei.hwmconf.sdk.dependency.IUiCustomImageHandler;
import com.huawei.hwmconf.sdk.model.conf.entity.HWMUiCustomImageInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.HWMUiCustomImageScene;
import com.huawei.hwmdemo.R;

import java.util.HashMap;
import java.util.Map;

public class CustomIUiCustomImageHandler implements IUiCustomImageHandler {

    @Override
    public HWMUiCustomImageInfo getImage(HWMUiCustomImageScene scene) {
        Map<HWMUiCustomImageScene, HWMUiCustomImageInfo> customImageMap = new HashMap<>();

        HWMUiCustomImageInfo cloudRecordIcon = new HWMUiCustomImageInfo();
        cloudRecordIcon.setImage(R.mipmap.hwmconf_ic_launcher)
                .setWidth(ViewGroup.LayoutParams.WRAP_CONTENT)
                .setHeight(ViewGroup.LayoutParams.WRAP_CONTENT);
        customImageMap.put(HWMUiCustomImageScene.CLOUD_RECORD_ICON_IMAGE_SCENE, cloudRecordIcon);

        HWMUiCustomImageInfo mainCloudRecord = new HWMUiCustomImageInfo();
        mainCloudRecord.setImage(R.mipmap.hwmconf_ic_launcher)
                .setWidth(ViewGroup.LayoutParams.WRAP_CONTENT)
                .setHeight(ViewGroup.LayoutParams.WRAP_CONTENT);
        customImageMap.put(HWMUiCustomImageScene.MAIN_WINDOW_CLOUD_RECORD_ICON_SCENE, mainCloudRecord);

        return customImageMap.get(scene);
    }
}
